/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.service.browser;

import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.xml.client.Element;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Entry {
    private String title;
    private String message;
    private String level;
    private String throwable;
    private Date eventTimestamp;
    @Nonnull
    private final LazyXmlParser xmlParser;

    public Entry(@Nonnull Node entryNode) {
        this.xmlParser = new LazyXmlParser(entryNode);
    }

    @Nonnull
    public String getTitle() {
        if (this.title == null) {
            this.title = this.avoidNull(this.xmlParser.getTitle());
        }
        return this.title;
    }

    @Nonnull
    public String getMessage() {
        if (this.message == null) {
            this.message = this.avoidNull(this.xmlParser.getMessage());
        }
        return this.message;
    }

    @Nonnull
    public String getLevel() {
        if (this.level == null) {
            this.level = this.avoidNull(this.xmlParser.getLevel());
        }
        return this.level;
    }

    @Nonnull
    public String getThrowable() {
        if (this.throwable == null) {
            this.throwable = this.avoidNull(this.xmlParser.getThrowable());
        }
        return this.throwable;
    }

    @Nullable
    public Date getEventTimestamp() {
        if (this.eventTimestamp == null) {
            this.eventTimestamp = this.xmlParser.getEventTimestamp();
        }
        return this.eventTimestamp != null ? (Date)this.eventTimestamp.clone() : null;
    }

    @Nonnull
    private String avoidNull(@Nullable String value) {
        return value != null ? value : "";
    }

    private static class LazyXmlParser {
        private static final String TITLE_TAG = "title";
        private static final String MESSAGE_TAG = "message";
        private static final String LEVEL_TAG = "level";
        private static final String THROWABLE_TAG = "throwable";
        private static final String EVENT_TIMESTAMP_TAG = "date";
        private static final DateTimeFormat DATETIME_FORMATTER = DateTimeFormat.getFormat((String)"yyyy-MM-ddTHH:mm:ss'.'SSSZ");
        @Nonnull
        private final Node entryNode;

        LazyXmlParser(@Nonnull Node entryNode) {
            assert ("entry".equals(entryNode.getNodeName()));
            assert (entryNode.getNodeType() == 1);
            this.entryNode = entryNode;
        }

        @Nullable
        private String getTagValue(@Nonnull String tagName) {
            Node node = this.getUniqueElementByTagName(tagName);
            return node != null ? this.getTextValue(node) : null;
        }

        @Nullable
        private Node getUniqueElementByTagName(@Nonnull String tagName) {
            NodeList nodes = ((Element)this.entryNode).getElementsByTagName(tagName);
            return nodes.getLength() == 1 ? nodes.item(0) : null;
        }

        @Nullable
        private String getTextValue(@Nonnull Node node) {
            Node child = node.getFirstChild();
            if (child != null && child.getNodeType() == 3) {
                return child.getNodeValue();
            }
            return null;
        }

        @Nullable
        public String getTitle() {
            return this.getTagValue(TITLE_TAG);
        }

        @Nullable
        public String getMessage() {
            return this.getTagValue(MESSAGE_TAG);
        }

        @Nullable
        public String getLevel() {
            return this.getTagValue(LEVEL_TAG);
        }

        @Nullable
        public String getThrowable() {
            return this.getTagValue(THROWABLE_TAG);
        }

        @Nullable
        public Date getEventTimestamp() {
            String value = this.getTagValue(EVENT_TIMESTAMP_TAG);
            return value != null ? DATETIME_FORMATTER.parse(value) : null;
        }
    }
}

