/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.counters;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.counters.Counter;
import org.apache.cxf.management.counters.MessageHandlingTimeRecorder;
import org.apache.cxf.management.counters.ResponseTimeCounter;
import org.apache.cxf.management.interceptor.ResponseTimeMessageInInterceptor;
import org.apache.cxf.management.interceptor.ResponseTimeMessageInvokerInterceptor;
import org.apache.cxf.management.interceptor.ResponseTimeMessageOutInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CounterRepository {
    private static final Logger LOG = LogUtils.getL7dLogger(CounterRepository.class);
    private Map<ObjectName, Counter> counters = new ConcurrentHashMap<ObjectName, Counter>();
    private Bus bus;

    @Resource(name="bus")
    public void setBus(Bus b) {
        this.bus = b;
    }

    public Bus getBus() {
        return this.bus;
    }

    public Map<ObjectName, Counter> getCounters() {
        return this.counters;
    }

    @PostConstruct
    void registerInterceptorsToBus() {
        ResponseTimeMessageInInterceptor in = new ResponseTimeMessageInInterceptor();
        ResponseTimeMessageInvokerInterceptor invoker = new ResponseTimeMessageInvokerInterceptor();
        ResponseTimeMessageOutInterceptor out = new ResponseTimeMessageOutInterceptor();
        this.bus.getInInterceptors().add(in);
        this.bus.getInInterceptors().add(invoker);
        this.bus.getOutInterceptors().add(out);
        this.bus.setExtension((Object)this, CounterRepository.class);
    }

    public void increaseCounter(ObjectName on, MessageHandlingTimeRecorder mhtr) {
        Counter counter = this.getCounter(on);
        if (null == counter) {
            counter = this.createCounter(on, mhtr);
            this.counters.put(on, counter);
        }
        counter.increase(mhtr);
    }

    public Counter getCounter(ObjectName on) {
        return this.counters.get(on);
    }

    public Counter createCounter(ObjectName on, MessageHandlingTimeRecorder mhtr) {
        ResponseTimeCounter counter = null;
        counter = new ResponseTimeCounter(on);
        InstrumentationManager im = (InstrumentationManager)this.bus.getExtension(InstrumentationManager.class);
        if (null != im) {
            try {
                im.register((ManagedComponent)counter);
            }
            catch (JMException e) {
                LOG.log(Level.WARNING, "INSTRUMENTATION_REGISTER_FAULT_MSG", new Object[]{e});
            }
        }
        return counter;
    }
}

