/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.RequiredModelMBean;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.ManagedBus;
import org.apache.cxf.buslifecycle.BusLifeCycleListener;
import org.apache.cxf.buslifecycle.BusLifeCycleManager;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.JMXConnectorPolicyType;
import org.apache.cxf.management.ManagedComponent;
import org.apache.cxf.management.jmx.MBServerConnectorFactory;
import org.apache.cxf.management.jmx.export.runtime.ModelMBeanAssembler;

public class InstrumentationManagerImpl
extends JMXConnectorPolicyType
implements InstrumentationManager,
BusLifeCycleListener {
    private static final Logger LOG = LogUtils.getL7dLogger(InstrumentationManagerImpl.class);
    private Bus bus;
    private MBServerConnectorFactory mcf;
    private MBeanServer mbs;
    private Set<ObjectName> busMBeans = new HashSet<ObjectName>();
    private boolean connectFailed;
    private String persistentBusId;
    private boolean createMBServerConnectorFactory = true;
    private String mbeanServerName = "org.apache.cxf";
    private boolean usePlatformMBeanServer;

    public Bus getBus() {
        return this.bus;
    }

    @Resource(name="cxf")
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public void setServerName(String s) {
        this.mbeanServerName = s;
    }

    public void setCreateMBServerConnectorFactory(boolean createMBServerConnectorFactory) {
        this.createMBServerConnectorFactory = createMBServerConnectorFactory;
    }

    public void setUsePlatformMBeanServer(Boolean flag) {
        this.usePlatformMBeanServer = flag;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, InstrumentationManager.class);
            BusLifeCycleManager blcm = (BusLifeCycleManager)this.bus.getExtension(BusLifeCycleManager.class);
            if (null != blcm) {
                blcm.registerLifeCycleListener((BusLifeCycleListener)this);
            }
        }
    }

    @PostConstruct
    public void init() {
        if (this.isEnabled()) {
            if (this.mbs == null) {
                List servers;
                this.mbs = this.usePlatformMBeanServer ? ManagementFactory.getPlatformMBeanServer() : ((servers = CastUtils.cast(MBeanServerFactory.findMBeanServer(this.mbeanServerName))).size() <= 1 ? MBeanServerFactory.createMBeanServer(this.mbeanServerName) : (MBeanServer)servers.get(0));
            }
            if (this.createMBServerConnectorFactory) {
                this.mcf = MBServerConnectorFactory.getInstance();
                this.mcf.setMBeanServer(this.mbs);
                this.mcf.setThreaded(this.isThreaded());
                this.mcf.setDaemon(this.isDaemon());
                this.mcf.setServiceUrl(this.getJMXServiceURL());
                try {
                    this.mcf.createConnector();
                }
                catch (IOException ex) {
                    this.connectFailed = true;
                    LOG.log(Level.SEVERE, "START_CONNECTOR_FAILURE_MSG", new Object[]{ex});
                }
            }
            if (!this.connectFailed && null != this.bus) {
                try {
                    ManagedBus mbus = new ManagedBus(this.bus);
                    this.register((ManagedComponent)mbus);
                }
                catch (JMException jmex) {
                    LOG.log(Level.SEVERE, "REGISTER_FAILURE_MSG", new Object[]{this.bus, jmex});
                }
            }
        }
    }

    public void register(Object obj, ObjectName name) throws JMException {
        this.register(obj, name, false);
    }

    public void register(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        if (!this.isEnabled() || this.connectFailed) {
            return;
        }
        try {
            this.registerMBeanWithServer(obj, this.persist(name), forceRegistration);
        }
        catch (NotCompliantMBeanException e) {
            ModelMBeanAssembler assembler = new ModelMBeanAssembler();
            ModelMBeanInfo mbi = assembler.getModelMbeanInfo(obj.getClass());
            this.register(obj, name, mbi, forceRegistration);
        }
    }

    public ObjectName register(ManagedComponent i) throws JMException {
        ObjectName name = this.register(i, false);
        return name;
    }

    public ObjectName register(ManagedComponent i, boolean forceRegistration) throws JMException {
        ObjectName name = i.getObjectName();
        this.register(i, name, forceRegistration);
        return name;
    }

    public void unregister(ManagedComponent component) throws JMException {
        ObjectName name = component.getObjectName();
        this.unregister(this.persist(name));
    }

    public void unregister(ObjectName name) throws JMException {
        if (!this.isEnabled() || this.connectFailed) {
            return;
        }
        this.busMBeans.remove(name);
        this.mbs.unregisterMBean(name);
    }

    public MBeanServer getMBeanServer() {
        return this.mbs;
    }

    public void setServer(MBeanServer server) {
        this.mbs = server;
    }

    public void shutdown() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mcf != null) {
            try {
                this.mcf.destroy();
            }
            catch (IOException ex) {
                LOG.log(Level.SEVERE, "STOP_CONNECTOR_FAILURE_MSG", new Object[]{ex});
            }
        }
    }

    public void initComplete() {
    }

    public void preShutdown() {
    }

    public void postShutdown() {
        Object[] mBeans;
        for (Object name : mBeans = this.busMBeans.toArray()) {
            this.busMBeans.remove((ObjectName)name);
            try {
                this.unregister((ObjectName)name);
            }
            catch (JMException jmex) {
                LOG.log(Level.SEVERE, "UNREGISTER_FAILURE_MSG", new Object[]{name, jmex});
            }
        }
    }

    private void register(Object obj, ObjectName name, ModelMBeanInfo mbi, boolean forceRegistration) throws JMException {
        RequiredModelMBean rtMBean = (RequiredModelMBean)this.mbs.instantiate("javax.management.modelmbean.RequiredModelMBean");
        rtMBean.setModelMBeanInfo(mbi);
        try {
            rtMBean.setManagedResource(obj, "ObjectReference");
        }
        catch (InvalidTargetObjectTypeException itotex) {
            throw new JMException(itotex.getMessage());
        }
        this.registerMBeanWithServer(rtMBean, this.persist(name), forceRegistration);
    }

    private void registerMBeanWithServer(Object obj, ObjectName name, boolean forceRegistration) throws JMException {
        ObjectInstance instance = null;
        try {
            instance = this.mbs.registerMBean(obj, name);
        }
        catch (InstanceAlreadyExistsException e) {
            if (forceRegistration) {
                this.mbs.unregisterMBean(name);
                instance = this.mbs.registerMBean(obj, name);
            }
            throw e;
        }
        if (instance != null) {
            this.busMBeans.add(name);
        }
    }

    public String getPersistentBusId() {
        return this.persistentBusId;
    }

    public void setPersistentBusId(String id) {
        this.persistentBusId = this.sanitize(id);
    }

    private ObjectName persist(ObjectName original) throws JMException {
        String originalStr;
        ObjectName persisted = original;
        if (this.persistentBusId != null && !"".equals(this.persistentBusId) && !this.persistentBusId.startsWith("${") && (originalStr = original.toString()).indexOf("bus.id") != -1) {
            String persistedStr = originalStr.replaceFirst("bus.id=" + this.bus.getId(), "bus.id=" + this.persistentBusId);
            persisted = new ObjectName(persistedStr);
        }
        return persisted;
    }

    private String sanitize(String in) {
        String result = null;
        if (in != null) {
            result = in.replace(':', '_');
            result = result.replace('/', '_');
            result = result.replace('\\', '_');
            result = result.replace('?', '_');
            result = result.replace('=', '_');
            result = result.replace(',', '_');
        }
        return result;
    }
}

