/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tracing;

import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public abstract class AbstractTracingProvider {
    protected static String getSpanIdHeader() {
        return AbstractTracingProvider.getHeaderOrDefault("org.apache.cxf.tracing.header.span_id", "X-Span-Id");
    }

    protected static String getTraceIdHeader() {
        return AbstractTracingProvider.getHeaderOrDefault("org.apache.cxf.tracing.header.trace_id", "X-Trace-Id");
    }

    private static String getHeaderOrDefault(String property, String fallback) {
        String name;
        Object header;
        Message message = PhaseInterceptorChain.getCurrentMessage();
        if (message != null && (header = message.getContextualProperty(property)) instanceof String && !StringUtils.isEmpty((String)(name = (String)header))) {
            return name;
        }
        return fallback;
    }

    protected String buildSpanDescription(String path, String method) {
        if (StringUtils.isEmpty((String)method)) {
            return path;
        }
        return method + " " + path;
    }
}

