/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.json.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.provider.json.utils.PrefixRespectingMappedNamespaceConvention;
import org.apache.cxf.staxutils.DelegatingXMLStreamWriter;
import org.apache.cxf.staxutils.DepthExceededStaxException;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.DocumentDepthProperties;
import org.apache.cxf.staxutils.transform.IgnoreNamespacesWriter;
import org.codehaus.jettison.AbstractXMLInputFactory;
import org.codehaus.jettison.badgerfish.BadgerFishXMLInputFactory;
import org.codehaus.jettison.badgerfish.BadgerFishXMLOutputFactory;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedNamespaceConvention;
import org.codehaus.jettison.mapped.MappedXMLInputFactory;
import org.codehaus.jettison.mapped.MappedXMLStreamReader;
import org.codehaus.jettison.mapped.MappedXMLStreamWriter;
import org.codehaus.jettison.mapped.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JSONUtils {
    private static final String XSI_PREFIX = "xsi";
    private static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final Charset UTF8 = Charset.forName("utf-8");

    private JSONUtils() {
    }

    public static XMLStreamWriter createBadgerFishWriter(OutputStream os) throws XMLStreamException {
        BadgerFishXMLOutputFactory factory = new BadgerFishXMLOutputFactory();
        return factory.createXMLStreamWriter(os);
    }

    public static XMLStreamReader createBadgerFishReader(InputStream is) throws XMLStreamException {
        BadgerFishXMLInputFactory factory = new BadgerFishXMLInputFactory();
        return factory.createXMLStreamReader(is);
    }

    public static XMLStreamWriter createStreamWriter(OutputStream os, QName qname, boolean writeXsiType, Configuration config, boolean serializeAsArray, List<String> arrayKeys, boolean dropRootElement) throws Exception {
        PrefixRespectingMappedNamespaceConvention convention = new PrefixRespectingMappedNamespaceConvention(config);
        MappedXMLStreamWriter xsw = new MappedXMLStreamWriter((MappedNamespaceConvention)convention, (Writer)new OutputStreamWriter(os, UTF8));
        if (serializeAsArray) {
            if (arrayKeys != null) {
                for (String key : arrayKeys) {
                    xsw.serializeAsArray(key);
                }
            } else {
                String key = JSONUtils.getKey(convention, qname);
                xsw.serializeAsArray(key);
            }
        }
        IgnoreContentJettisonWriter writer = !writeXsiType || dropRootElement ? new IgnoreContentJettisonWriter((XMLStreamWriter)xsw, writeXsiType, dropRootElement ? qname : null) : xsw;
        return writer;
    }

    public static Configuration createConfiguration(ConcurrentHashMap<String, String> namespaceMap, boolean writeXsiType, boolean attributesAsElements, TypeConverter converter) {
        if (writeXsiType) {
            namespaceMap.putIfAbsent(XSI_URI, XSI_PREFIX);
        }
        Configuration c = new Configuration(namespaceMap);
        c.setSupressAtAttributes(attributesAsElements);
        if (converter != null) {
            c.setTypeConverter(converter);
        }
        return c;
    }

    public static XMLStreamWriter createIgnoreMixedContentWriterIfNeeded(XMLStreamWriter writer, boolean ignoreMixedContent) {
        return ignoreMixedContent ? new IgnoreMixedContentWriter(writer) : writer;
    }

    public static XMLStreamWriter createIgnoreNsWriterIfNeeded(XMLStreamWriter writer, boolean ignoreNamespaces) {
        return ignoreNamespaces ? new IgnoreNamespacesWriter(writer) : writer;
    }

    private static String getKey(MappedNamespaceConvention convention, QName qname) throws Exception {
        return convention.createKey(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart());
    }

    public static XMLStreamReader createStreamReader(InputStream is, boolean readXsiType, ConcurrentHashMap<String, String> namespaceMap) throws Exception {
        return JSONUtils.createStreamReader(is, readXsiType, namespaceMap, null);
    }

    public static XMLStreamReader createStreamReader(InputStream is, boolean readXsiType, ConcurrentHashMap<String, String> namespaceMap, DocumentDepthProperties depthProps) throws Exception {
        if (readXsiType) {
            namespaceMap.putIfAbsent(XSI_URI, XSI_PREFIX);
        }
        JettisonMappedReaderFactory factory = depthProps != null ? new JettisonMappedReaderFactory(namespaceMap, depthProps) : new MappedXMLInputFactory(namespaceMap);
        return new JettisonReader(namespaceMap, ((XMLInputFactory)((Object)factory)).createXMLStreamReader(is));
    }

    private static class IgnoreMixedContentWriter
    extends DelegatingXMLStreamWriter {
        String lastText;
        boolean isMixed;
        List<Boolean> mixed = new LinkedList<Boolean>();

        public IgnoreMixedContentWriter(XMLStreamWriter writer) {
            super(writer);
        }

        public void writeCharacters(String text) throws XMLStreamException {
            if (StringUtils.isEmpty((String)text.trim())) {
                this.lastText = text;
            } else if (this.lastText != null) {
                this.lastText = this.lastText + text;
            } else if (!this.isMixed) {
                super.writeCharacters(text);
            } else {
                this.lastText = text;
            }
        }

        public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(prefix, local, uri);
        }

        public void writeStartElement(String uri, String local) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(uri, local);
        }

        public void writeStartElement(String local) throws XMLStreamException {
            if (this.lastText != null) {
                this.isMixed = true;
            }
            this.mixed.add(0, this.isMixed);
            this.lastText = null;
            this.isMixed = false;
            super.writeStartElement(local);
        }

        public void writeEndElement() throws XMLStreamException {
            if (!(this.lastText == null || this.isMixed && StringUtils.isEmpty((String)this.lastText.trim()))) {
                super.writeCharacters(this.lastText.trim());
            }
            super.writeEndElement();
            this.isMixed = this.mixed.get(0);
            this.mixed.remove(0);
        }
    }

    private static class IgnoreContentJettisonWriter
    extends DelegatingXMLStreamWriter {
        private boolean writeXsiType;
        private QName ignoredQName;
        private boolean rootDropped;
        private int index;

        public IgnoreContentJettisonWriter(XMLStreamWriter writer, boolean writeXsiType, QName qname) {
            super(writer);
            this.writeXsiType = writeXsiType;
            this.ignoredQName = qname;
        }

        public void writeAttribute(String prefix, String uri, String local, String value) throws XMLStreamException {
            if (!this.writeXsiType && JSONUtils.XSI_PREFIX.equals(prefix) && ("type".equals(local) || "nil".equals(local))) {
                return;
            }
            super.writeAttribute(prefix, uri, local, value);
        }

        public void writeStartElement(String prefix, String local, String uri) throws XMLStreamException {
            ++this.index;
            if (this.ignoredQName != null && this.ignoredQName.getLocalPart().equals(local) && this.ignoredQName.getNamespaceURI().equals(uri)) {
                this.rootDropped = true;
                return;
            }
            super.writeStartElement(prefix, local, uri);
        }

        public void writeStartElement(String local) throws XMLStreamException {
            this.writeStartElement("", local, "");
        }

        public void writeEndElement() throws XMLStreamException {
            --this.index;
            if (this.rootDropped && this.index == 0) {
                return;
            }
            super.writeEndElement();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JettisonReader
    extends DepthXMLStreamReader {
        private Map<String, String> namespaceMap;

        public JettisonReader(Map<String, String> nsMap, XMLStreamReader reader) {
            super(reader);
            this.namespaceMap = nsMap;
        }

        public String getAttributePrefix(int n) {
            QName name = this.getAttributeName(n);
            if (name != null && JSONUtils.XSI_URI.equals(name.getNamespaceURI())) {
                return JSONUtils.XSI_PREFIX;
            }
            return super.getAttributePrefix(n);
        }

        public NamespaceContext getNamespaceContext() {
            return new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    for (Map.Entry entry : JettisonReader.this.namespaceMap.entrySet()) {
                        if (!((String)entry.getValue()).equals(prefix)) continue;
                        return (String)entry.getKey();
                    }
                    return null;
                }

                @Override
                public String getPrefix(String ns) {
                    return (String)JettisonReader.this.namespaceMap.get(ns);
                }

                public Iterator<?> getPrefixes(String ns) {
                    String prefix = this.getPrefix(ns);
                    return prefix == null ? null : Collections.singletonList(prefix).iterator();
                }
            };
        }
    }

    private static class JettisonJSONObject
    extends JSONObject {
        private static final long serialVersionUID = 9016458891093343731L;
        private int threshold;

        public JettisonJSONObject(JSONTokener x, DocumentDepthProperties depthProps) throws JSONException {
            int n = this.threshold = depthProps.getElementCountThreshold() != -1 ? depthProps.getElementCountThreshold() : depthProps.getInnerElementCountThreshold();
            if (x.nextClean() != '{') {
                throw x.syntaxError("A JSONObject text must begin with '{'");
            }
            block8: while (true) {
                char c = x.nextClean();
                switch (c) {
                    case '\u0000': {
                        throw x.syntaxError("A JSONObject text must end with '}'");
                    }
                    case '}': {
                        return;
                    }
                }
                x.back();
                String key = x.nextValue().toString();
                c = x.nextClean();
                if (c == '=') {
                    if (x.next() != '>') {
                        x.back();
                    }
                } else if (c != ':') {
                    throw x.syntaxError("Expected a ':' after a key");
                }
                this.put(key, x.nextValue());
                switch (x.nextClean()) {
                    case ',': 
                    case ';': {
                        if (x.nextClean() == '}') {
                            return;
                        }
                        x.back();
                        continue block8;
                    }
                    case '}': {
                        return;
                    }
                }
                break;
            }
            throw new JSONException("Expected a ',' or '}'");
        }

        public JSONObject put(String key, Object value) throws JSONException {
            JSONObject obj = super.put(key, value);
            if (this.threshold != -1 && super.length() >= this.threshold) {
                throw new DepthExceededStaxException();
            }
            return obj;
        }
    }

    private static class JettisonJSONTokener
    extends JSONTokener {
        private DocumentDepthProperties depthProps;

        public JettisonJSONTokener(String s, DocumentDepthProperties depthProps) {
            super(s);
            this.depthProps = depthProps;
        }

        public Object nextValue() throws JSONException {
            char c = this.nextClean();
            switch (c) {
                case '\"': 
                case '\'': {
                    return this.nextString(c);
                }
                case '{': {
                    this.back();
                    return new JettisonJSONObject(this, this.depthProps);
                }
                case '[': {
                    this.back();
                    return new JSONArray((JSONTokener)this);
                }
            }
            return this.finalize(c);
        }

        private Object finalize(char c) throws JSONException {
            StringBuffer sb = new StringBuffer();
            char b = c;
            while (c >= ' ' && ",:]}/\\\"[{;=#".indexOf(c) < 0) {
                sb.append(c);
                c = this.next();
            }
            this.back();
            String s = sb.toString().trim();
            if (s.length() == 0) {
                throw new JSONException("Missing value.");
            }
            Object res = null;
            if (s.equalsIgnoreCase("true")) {
                res = Boolean.TRUE;
            } else if (s.equalsIgnoreCase("false")) {
                res = Boolean.FALSE;
            } else if (s.equalsIgnoreCase("null")) {
                res = JSONObject.NULL;
            }
            if (res != null) {
                return res;
            }
            if (b >= '0' && b <= '9' || b == '.' || b == '-' || b == '+') {
                if (b == '0') {
                    if (s.length() > 2 && (s.charAt(1) == 'x' || s.charAt(1) == 'X')) {
                        try {
                            res = new Integer(Integer.parseInt(s.substring(2), 16));
                        }
                        catch (Exception e) {}
                    } else {
                        try {
                            res = new Integer(Integer.parseInt(s, 8));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                if (res == null) {
                    try {
                        res = new Integer(s);
                    }
                    catch (Exception e) {
                        try {
                            res = new Long(s);
                        }
                        catch (Exception f) {
                            try {
                                res = new Double(s);
                            }
                            catch (Exception g) {
                                res = s;
                            }
                        }
                    }
                }
                if (res != null) {
                    return res;
                }
            }
            return s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JettisonMappedReaderFactory
    extends AbstractXMLInputFactory {
        private static final int INPUT_BUF_SIZE = 4096;
        private MappedNamespaceConvention convention;
        private DocumentDepthProperties depthProps;

        public JettisonMappedReaderFactory(Map<?, ?> nstojns, DocumentDepthProperties depthProps) {
            this.convention = new MappedNamespaceConvention(new Configuration(nstojns));
            this.depthProps = depthProps;
        }

        public XMLStreamReader createXMLStreamReader(JSONTokener tokener) throws XMLStreamException {
            try {
                JettisonJSONObject root = new JettisonJSONObject(tokener, this.depthProps);
                return new MappedXMLStreamReader((JSONObject)root, this.convention);
            }
            catch (JSONException e) {
                throw new XMLStreamException(e);
            }
        }

        private String readAll(InputStream in, String encoding) throws IOException {
            int count;
            byte[] buffer = new byte[4096];
            ByteArrayOutputStream bos = null;
            while ((count = in.read(buffer)) >= 0) {
                if (bos == null) {
                    int cap = count < 64 ? 64 : (count == 4096 ? 16384 : count);
                    bos = new ByteArrayOutputStream(cap);
                }
                bos.write(buffer, 0, count);
            }
            return bos == null ? "" : bos.toString(encoding);
        }

        public XMLStreamReader createXMLStreamReader(InputStream is, String charset) throws XMLStreamException {
            if (charset == null) {
                charset = "UTF-8";
            }
            try {
                String doc = this.readAll(is, charset);
                return this.createXMLStreamReader(new JettisonJSONTokener(doc, this.depthProps));
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }
    }
}

