/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.atom;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.ExtensibleElement;
import org.apache.abdera.model.Feed;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.JAXBElementProvider;
import org.apache.cxf.jaxrs.provider.atom.AbstractAtomElementBuilder;
import org.apache.cxf.jaxrs.provider.atom.AbstractEntryBuilder;
import org.apache.cxf.jaxrs.provider.atom.AbstractFeedBuilder;
import org.apache.cxf.jaxrs.provider.atom.AtomElementReader;
import org.apache.cxf.jaxrs.provider.atom.AtomElementWriter;
import org.apache.cxf.jaxrs.provider.atom.AtomEntryProvider;
import org.apache.cxf.jaxrs.provider.atom.AtomFeedProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Produces(value={"application/atom+xml", "application/atom+xml;type=feed", "application/atom+xml;type=entry"})
@Consumes(value={"application/atom+xml", "application/atom+xml;type=feed", "application/atom+xml;type=entry"})
@Provider
public class AtomPojoProvider
extends AbstractConfigurableProvider
implements MessageBodyWriter<Object>,
MessageBodyReader<Object> {
    private static final Logger LOG = LogUtils.getL7dLogger(AtomPojoProvider.class);
    private static final Abdera ATOM_ENGINE = new Abdera();
    private static final String DEFAULT_ENTRY_CONTENT_METHOD = "getContent";
    private JAXBElementProvider<Object> jaxbProvider = new JAXBElementProvider();
    private Map<String, String> collectionGetters = Collections.emptyMap();
    private Map<String, String> collectionSetters = Collections.emptyMap();
    private Map<Class<?>, AtomElementWriter<?, ?>> atomClassWriters = Collections.emptyMap();
    private Map<Class<?>, AtomElementReader<?, ?>> atomClassReaders = Collections.emptyMap();
    private Map<Class<?>, AbstractAtomElementBuilder<?>> atomClassBuilders = Collections.emptyMap();
    private Map<String, AtomElementWriter<?, ?>> atomWriters = Collections.emptyMap();
    private Map<String, AtomElementReader<?, ?>> atomReaders = Collections.emptyMap();
    private Map<String, AbstractAtomElementBuilder<?>> atomBuilders = Collections.emptyMap();
    private MessageContext mc;
    private boolean formattedOutput;
    private boolean useJaxbForContent = true;
    private String entryContentMethodName = "getContent";

    public void setUseJaxbForContent(boolean use) {
        this.useJaxbForContent = use;
    }

    public void setEntryContentMethodName(String name) {
        this.entryContentMethodName = name;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
        for (AbstractAtomElementBuilder<?> abstractAtomElementBuilder : this.atomClassBuilders.values()) {
            abstractAtomElementBuilder.setMessageContext(context);
        }
        for (AtomElementWriter atomElementWriter : this.atomClassWriters.values()) {
            this.tryInjectMessageContext(atomElementWriter);
        }
        for (AtomElementReader atomElementReader : this.atomClassReaders.values()) {
            this.tryInjectMessageContext(atomElementReader);
        }
        for (AbstractAtomElementBuilder abstractAtomElementBuilder : this.atomBuilders.values()) {
            abstractAtomElementBuilder.setMessageContext(context);
        }
        for (AtomElementWriter atomElementWriter : this.atomWriters.values()) {
            this.tryInjectMessageContext(atomElementWriter);
        }
        for (AtomElementReader atomElementReader : this.atomReaders.values()) {
            this.tryInjectMessageContext(atomElementReader);
        }
    }

    protected void tryInjectMessageContext(Object handler) {
        try {
            Method m = handler.getClass().getMethod("setMessageContext", MessageContext.class);
            InjectionUtils.injectThroughMethod((Object)handler, (Method)m, (Object)this.mc);
        }
        catch (Throwable t) {
            LOG.warning("Message context can not be injected into " + handler.getClass().getName() + " : " + t.getMessage());
        }
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return -1L;
    }

    public void setCollectionGetters(Map<String, String> methods) {
        this.collectionGetters = methods;
    }

    public void setCollectionSetters(Map<String, String> methods) {
        this.collectionSetters = methods;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mt) {
        return !Feed.class.isAssignableFrom(type) && !Entry.class.isAssignableFrom(type);
    }

    public void writeTo(Object o, Class<?> cls, Type genericType, Annotation[] annotations, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException {
        boolean isFeed = this.isFeedRequested(mt);
        boolean isCollection = InjectionUtils.isSupportedCollectionOrArray(cls);
        if (isFeed && isCollection) {
            this.reportError("Atom feed can only be created from a collection wrapper", null);
        } else if (!isFeed && isCollection) {
            this.reportError("Atom entry can only be created from a single object", null);
        }
        Factory factory = Abdera.getNewFactory();
        Feed atomElement = null;
        try {
            if (isFeed && !isCollection) {
                atomElement = this.createFeedFromCollectionWrapper(factory, o, cls);
            } else if (!isFeed && !isCollection) {
                atomElement = this.createEntryFromObject(factory, o, cls);
            }
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        try {
            this.writeAtomElement((Element)atomElement, os);
        }
        catch (IOException ex) {
            this.reportError("Atom element can not be serialized", ex);
        }
    }

    private void writeAtomElement(Element atomElement, OutputStream os) throws IOException {
        org.apache.abdera.writer.Writer w;
        org.apache.abdera.writer.Writer writer = w = this.formattedOutput ? this.createWriter("prettyxml") : null;
        if (w != null) {
            atomElement.writeTo(w, os);
        } else {
            atomElement.writeTo(os);
        }
    }

    protected org.apache.abdera.writer.Writer createWriter(String writerName) {
        return ATOM_ENGINE.getWriterFactory().getWriter(writerName);
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    protected Feed createFeedFromCollectionWrapper(Factory factory, Object o, Class<?> pojoClass) throws Exception {
        Feed feed = factory.newFeed();
        boolean writerUsed = this.buildFeed(feed, o, pojoClass);
        if (feed.getEntries().size() > 0) {
            return feed;
        }
        String methodName = this.getCollectionMethod(o.getClass(), true);
        Object collection = null;
        Method m = null;
        try {
            m = o.getClass().getMethod(methodName, new Class[0]);
            collection = m.invoke(o, new Object[0]);
        }
        catch (Exception ex) {
            this.reportError("Collection for " + o.getClass().getName() + " can not be retrieved", ex);
        }
        this.setFeedFromCollection(factory, feed, o, pojoClass, collection, m.getReturnType(), m.getGenericReturnType(), writerUsed);
        return feed;
    }

    private String getCollectionMethod(Class<?> cls, boolean getter) {
        Map<String, String> map = getter ? this.collectionGetters : this.collectionSetters;
        String methodName = this.getCollectionMethod(map, cls);
        if (methodName == null) {
            try {
                Class[] classArray;
                methodName = (getter ? "get" : "set") + cls.getSimpleName();
                if (getter) {
                    classArray = new Class[]{};
                } else {
                    Class[] classArray2 = new Class[1];
                    classArray = classArray2;
                    classArray2[0] = List.class;
                }
                Class[] params = classArray;
                cls.getMethod(methodName, params);
            }
            catch (Exception ex) {
                String type = getter ? "getter" : "setter";
                this.reportError("Collection " + type + " method for " + cls.getName() + " has not been specified and no default " + methodName + " is available", null);
            }
        }
        return methodName;
    }

    private String getCollectionMethod(Map<String, String> map, Class<?> pojoClass) {
        if (pojoClass == Object.class) {
            return null;
        }
        String method = map.get(pojoClass.getName());
        if (method != null) {
            return method;
        }
        return this.getCollectionMethod(map, pojoClass.getSuperclass());
    }

    protected <X> boolean buildFeed(Feed feed, X o, Class<?> pojoClass) {
        AtomElementWriter<?, ?> builder = this.getAtomWriter(pojoClass);
        if (builder != null) {
            builder.writeTo(feed, o);
            return true;
        }
        return false;
    }

    protected AtomElementWriter<?, ?> getAtomWriter(Class<?> pojoClass) {
        AtomElementWriter<?, ?> writer = this.getAtomClassElementHandler(this.atomClassWriters, pojoClass);
        return writer == null && this.atomWriters != null ? this.getAtomElementHandler(this.atomWriters, pojoClass) : writer;
    }

    protected AtomElementReader<?, ?> getAtomReader(Class<?> pojoClass) {
        AtomElementReader<?, ?> reader = this.getAtomClassElementHandler(this.atomClassReaders, pojoClass);
        return reader == null && this.atomReaders != null ? this.getAtomElementHandler(this.atomReaders, pojoClass) : reader;
    }

    private <T> T getAtomClassElementHandler(Map<Class<?>, T> handlers, Class<?> pojoClass) {
        for (Map.Entry<Class<?>, T> entry : handlers.entrySet()) {
            if (!entry.getKey().isAssignableFrom(pojoClass)) continue;
            return entry.getValue();
        }
        return null;
    }

    protected <T> T getAtomElementHandler(Map<String, T> handlers, Class<?> pojoClass) {
        T handler = this.getAtomElementHandlerSuperClass(handlers, pojoClass);
        if (handler == null) {
            Class<?> inter;
            Class<?>[] interfaces;
            Class<?>[] arr$ = interfaces = pojoClass.getInterfaces();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (handler = handlers.get((inter = arr$[i$]).getName())) == null; ++i$) {
            }
        }
        return handler;
    }

    private <T> T getAtomElementHandlerSuperClass(Map<String, T> handlers, Class<?> pojoClass) {
        if (pojoClass == null || pojoClass == Object.class) {
            return null;
        }
        T handler = handlers.get(pojoClass.getName());
        if (handler != null) {
            return handler;
        }
        return this.getAtomElementHandlerSuperClass(handlers, pojoClass.getSuperclass());
    }

    protected void setFeedFromCollection(Factory factory, Feed feed, Object wrapper, Class<?> wrapperCls, Object collection, Class<?> collectionCls, Type collectionType, boolean writerUsed) throws Exception {
        Object[] arr = collectionCls.isArray() ? (Object[])collection : ((Collection)collection).toArray();
        Class memberClass = InjectionUtils.getActualType((Type)collectionType);
        for (Object o : arr) {
            Entry entry = this.createEntryFromObject(factory, o, memberClass);
            feed.addEntry(entry);
        }
        if (!writerUsed) {
            this.setFeedProperties(factory, feed, wrapper, wrapperCls, collection, collectionCls, collectionType);
        }
    }

    protected AbstractAtomElementBuilder<?> getAtomBuilder(Class<?> pojoClass) {
        AbstractAtomElementBuilder<?> builder = this.getAtomClassElementHandler(this.atomClassBuilders, pojoClass);
        return builder == null && this.atomBuilders != null ? this.getAtomElementHandler(this.atomBuilders, pojoClass) : builder;
    }

    protected void setFeedProperties(Factory factory, Feed feed, Object wrapper, Class<?> wrapperCls, Object collection, Class<?> collectionCls, Type collectionType) {
        String icon;
        String logo;
        List<String> terms;
        AbstractAtomElementBuilder<Object> builder = this.getAtomBuilder(wrapperCls);
        if (builder == null) {
            return;
        }
        this.setCommonElementProperties(factory, (ExtensibleElement)feed, builder, wrapper);
        AbstractFeedBuilder theBuilder = (AbstractFeedBuilder)builder;
        String author = theBuilder.getAuthor(wrapper);
        if (author != null) {
            feed.addAuthor(author);
        } else {
            feed.addAuthor("CXF JAX-RS");
        }
        String title = theBuilder.getTitle(wrapper);
        if (title != null) {
            feed.setTitle(title);
        } else {
            feed.setTitle(String.format(wrapper.getClass().getSimpleName() + " collection with %d entry(ies)", feed.getEntries().size()));
        }
        String id = theBuilder.getId(wrapper);
        if (id != null) {
            feed.setId(id);
        } else {
            feed.setId("uuid:" + UUID.randomUUID().toString());
        }
        String updated = theBuilder.getUpdated(wrapper);
        if (updated != null) {
            feed.setUpdated(updated);
        } else {
            feed.setUpdated(new Date());
        }
        Map<String, String> links = theBuilder.getLinks(wrapper);
        if (links != null) {
            for (Map.Entry<String, String> entry : links.entrySet()) {
                feed.addLink(entry.getKey(), entry.getValue());
            }
        }
        if ((terms = theBuilder.getCategories(wrapper)) != null) {
            for (String term : terms) {
                feed.addCategory(term);
            }
        }
        if ((logo = theBuilder.getLogo(wrapper)) != null) {
            feed.setLogo(logo);
        }
        if ((icon = theBuilder.getLogo(wrapper)) != null) {
            feed.setIcon(icon);
        }
    }

    protected Entry createEntryFromObject(Factory factory, Object o, Class<?> cls) throws Exception {
        Entry entry = factory.getAbdera().newEntry();
        if (!this.buildEntry(entry, o, cls)) {
            this.setEntryProperties(factory, entry, o, cls);
        }
        if (entry.getContentElement() == null && entry.getExtensions().size() == 0) {
            this.createEntryContent(factory, entry, o, cls);
        }
        return entry;
    }

    protected boolean buildEntry(Entry entry, Object o, Class<?> pojoClass) {
        AtomElementWriter<?, ?> builder = this.getAtomWriter(pojoClass);
        if (builder != null) {
            builder.writeTo(entry, o);
            return true;
        }
        return false;
    }

    protected void createEntryContent(Factory factory, Entry e, Object o, Class<?> cls) throws Exception {
        String content = null;
        if (this.useJaxbForContent) {
            JAXBContext jc = this.jaxbProvider.getJAXBContext(cls, cls);
            StringWriter writer = new StringWriter();
            jc.createMarshaller().marshal(o, (Writer)writer);
            content = writer.toString();
        } else {
            Method m = cls.getMethod(this.entryContentMethodName, new Class[0]);
            content = (String)m.invoke(o, new Object[0]);
        }
        this.setEntryContent(factory, e, content);
    }

    protected void setEntryContent(Factory factory, Entry e, String content) {
        Content ct = factory.newContent(Content.Type.XML);
        ct.setValue(content);
        e.setContentElement(ct);
    }

    protected void setEntryProperties(Factory factory, Entry entry, Object o, Class<?> cls) {
        String content;
        List<String> terms;
        String summary;
        String published;
        AbstractAtomElementBuilder<Object> builder = this.getAtomBuilder(cls);
        if (builder == null) {
            return;
        }
        this.setCommonElementProperties(factory, (ExtensibleElement)entry, builder, o);
        AbstractEntryBuilder theBuilder = (AbstractEntryBuilder)builder;
        String author = theBuilder.getAuthor(o);
        if (author != null) {
            entry.addAuthor(author);
        } else {
            entry.addAuthor("CXF JAX-RS");
        }
        String title = theBuilder.getTitle(o);
        if (title != null) {
            entry.setTitle(title);
        } else {
            entry.setTitle(o.getClass().getSimpleName());
        }
        String id = theBuilder.getId(o);
        if (id != null) {
            entry.setId(id);
        } else {
            entry.setId("uuid:" + UUID.randomUUID().toString());
        }
        String updated = theBuilder.getUpdated(o);
        if (updated != null) {
            entry.setUpdated(updated);
        } else {
            entry.setUpdated(new Date());
        }
        Map<String, String> links = theBuilder.getLinks(o);
        if (links != null) {
            for (Map.Entry<String, String> e : links.entrySet()) {
                entry.addLink(e.getKey(), e.getValue());
            }
        }
        if ((published = theBuilder.getPublished(o)) != null) {
            entry.setPublished(published);
        }
        if ((summary = theBuilder.getSummary(o)) != null) {
            entry.setSummary(summary);
        }
        if ((terms = theBuilder.getCategories(o)) != null) {
            for (String term : terms) {
                entry.addCategory(term);
            }
        }
        if ((content = theBuilder.getContent(o)) != null) {
            this.setEntryContent(factory, entry, content);
        }
    }

    private void setCommonElementProperties(Factory factory, ExtensibleElement element, AbstractAtomElementBuilder<Object> builder, Object o) {
        String baseUri = builder.getBaseUri(o);
        if (baseUri != null) {
            element.setBaseUri(baseUri);
        }
    }

    private void reportError(String message, Exception ex, int status) {
        LOG.warning(message);
        Response response = Response.status((int)status).type("text/plain").entity((Object)message).build();
        if (ex == null) {
            throw new WebApplicationException(response);
        }
        throw new WebApplicationException((Throwable)ex, response);
    }

    private void reportError(String message, Exception ex) {
        this.reportError(message, ex, 500);
    }

    private boolean isFeedRequested(MediaType mt) {
        return !"entry".equals(mt.getParameters().get("type"));
    }

    public void setAtomWriters(Map<String, AtomElementWriter<?, ?>> writers) {
        this.atomWriters = writers;
    }

    public void setAtomReaders(Map<String, AtomElementReader<?, ?>> readers) {
        this.atomReaders = readers;
    }

    public void setAtomBuilders(Map<String, AbstractAtomElementBuilder<?>> builders) {
        this.atomBuilders = builders;
    }

    public void setAtomClassWriters(Map<Class<?>, AtomElementWriter<?, ?>> writers) {
        this.atomClassWriters = writers;
    }

    public void setAtomClassReaders(Map<Class<?>, AtomElementReader<?, ?>> readers) {
        this.atomClassReaders = readers;
    }

    public void setAtomClassBuilders(Map<Class<?>, AbstractAtomElementBuilder<?>> builders) {
        this.atomClassBuilders = builders;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public Object readFrom(Class<Object> cls, Type type, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        boolean isFeed = this.isFeedRequested(mt);
        if (isFeed) {
            return this.readFromFeed(cls, mt, headers, is);
        }
        Entry entry = new AtomEntryProvider().readFrom(Entry.class, (Type)((Object)Entry.class), new Annotation[0], mt, headers, is);
        return this.readFromEntry(entry, cls, mt, headers, is);
    }

    private Object readFromFeed(Class<Object> cls, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        AtomFeedProvider p = new AtomFeedProvider();
        Feed feed = p.readFrom(Feed.class, (Type)((Object)Feed.class), new Annotation[0], mt, headers, is);
        AtomElementReader<?, ?> reader = this.getAtomReader(cls);
        if (reader != null) {
            return reader.readFrom(feed);
        }
        Object instance = null;
        try {
            String methodName = this.getCollectionMethod(cls, false);
            Method m = cls.getMethod(methodName, List.class);
            Class realCls = InjectionUtils.getActualType((Type)m.getGenericParameterTypes()[0]);
            ArrayList<Object> objects = new ArrayList<Object>();
            for (Entry e : feed.getEntries()) {
                objects.add(this.readFromEntry(e, realCls, mt, headers, is));
            }
            instance = cls.newInstance();
            m.invoke(instance, objects);
        }
        catch (Exception ex) {
            this.reportError("Object of type " + cls.getName() + " can not be deserialized from Feed", ex, 400);
        }
        return instance;
    }

    private Object readFromEntry(Entry entry, Class<Object> cls, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        AtomElementReader<?, ?> reader = this.getAtomReader(cls);
        if (reader != null) {
            return reader.readFrom(entry);
        }
        try {
            Unmarshaller um = this.jaxbProvider.getJAXBContext(cls, cls).createUnmarshaller();
            return cls.cast(um.unmarshal((Reader)new StringReader(entry.getContent())));
        }
        catch (Exception ex) {
            this.reportError("Object of type " + cls.getName() + " can not be deserialized from Entry", ex, 400);
            return null;
        }
    }
}

