/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.swaggerutil;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.model.UserOperation;
import org.apache.cxf.jaxrs.model.UserResource;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.utils.ResourceUtils;

public final class SwaggerUtils {
    private static final Logger LOG = LogUtils.getL7dLogger(ResourceUtils.class);
    private static final Map<String, String> SWAGGER_TYPE_MAP = new HashMap<String, String>();

    private SwaggerUtils() {
    }

    public static UserResource getUserResource(String loc) {
        return SwaggerUtils.getUserResource(loc, BusFactory.getThreadDefaultBus());
    }

    public static UserResource getUserResource(String loc, Bus bus) {
        try {
            InputStream is = ResourceUtils.getResourceStream((String)loc, (Bus)bus);
            if (is == null) {
                return null;
            }
            return SwaggerUtils.getUserResourceFromJson(IOUtils.readStringFromStream((InputStream)is));
        }
        catch (Exception ex) {
            LOG.warning("Problem with processing a user model at " + loc);
            return null;
        }
    }

    public static List<UserResource> getUserResourcesFromResourceObjects(List<String> jsonObjects) {
        ArrayList<UserResource> resources = new ArrayList<UserResource>();
        for (String json : jsonObjects) {
            resources.add(SwaggerUtils.getUserResourceFromJson(json));
        }
        return resources;
    }

    public static UserResource getUserResourceFromJson(String json) {
        JsonMapObjectReaderWriter reader = new JsonMapObjectReaderWriter();
        Map<String, Object> map = reader.fromJson(json);
        if (map.containsKey("swaggerVersion")) {
            return SwaggerUtils.getUserResourceFromSwagger12(map);
        }
        return SwaggerUtils.getUserResourceFromSwagger20(map);
    }

    private static UserResource getUserResourceFromSwagger20(Map<String, Object> map) {
        UserResource ur = new UserResource();
        String relativePath = (String)map.get("basePath");
        ur.setPath(relativePath == null ? "/" : relativePath);
        List resourceProduces = CastUtils.cast((List)((List)map.get("produces")));
        ur.setProduces(SwaggerUtils.listToString(resourceProduces));
        List resourceConsumes = CastUtils.cast((List)((List)map.get("consumes")));
        ur.setConsumes(SwaggerUtils.listToString(resourceConsumes));
        LinkedList<UserOperation> userOps = new LinkedList<UserOperation>();
        Map paths = CastUtils.cast((Map)((Map)map.get("paths")));
        for (Map.Entry pathEntry : paths.entrySet()) {
            String operPath = (String)pathEntry.getKey();
            Map operations = (Map)pathEntry.getValue();
            for (Map.Entry operEntry : operations.entrySet()) {
                UserOperation userOp = new UserOperation();
                userOp.setVerb(((String)operEntry.getKey()).toUpperCase());
                userOp.setPath(operPath);
                Map oper = CastUtils.cast((Map)((Map)operEntry.getValue()));
                userOp.setName((String)oper.get("operationId"));
                List opProduces = CastUtils.cast((List)((List)oper.get("produces")));
                userOp.setProduces(SwaggerUtils.listToString(opProduces));
                List opConsumes = CastUtils.cast((List)((List)oper.get("consumes")));
                userOp.setConsumes(SwaggerUtils.listToString(opConsumes));
                LinkedList<Parameter> userOpParams = new LinkedList<Parameter>();
                List params = CastUtils.cast((List)((List)oper.get("parameters")));
                for (Map param : params) {
                    String name = (String)param.get("name");
                    String paramType = (String)param.get("in");
                    ParameterType pType = "body".equals(paramType) ? ParameterType.REQUEST_BODY : ("formData".equals(paramType) ? ParameterType.FORM : ParameterType.valueOf((String)paramType.toUpperCase()));
                    Parameter userParam = new Parameter(pType, name);
                    SwaggerUtils.setJavaType(userParam, (String)param.get("type"));
                    userOpParams.add(userParam);
                }
                if (!userOpParams.isEmpty()) {
                    userOp.setParameters(userOpParams);
                }
                userOps.add(userOp);
            }
        }
        ur.setOperations(userOps);
        return ur;
    }

    private static UserResource getUserResourceFromSwagger12(Map<String, Object> map) {
        UserResource ur = new UserResource();
        String relativePath = (String)map.get("resourcePath");
        ur.setPath(relativePath == null ? "/" : relativePath);
        List resourceProduces = CastUtils.cast((List)((List)map.get("produces")));
        ur.setProduces(SwaggerUtils.listToString(resourceProduces));
        List resourceConsumes = CastUtils.cast((List)((List)map.get("consumes")));
        ur.setConsumes(SwaggerUtils.listToString(resourceConsumes));
        LinkedList<UserOperation> userOps = new LinkedList<UserOperation>();
        List apis = CastUtils.cast((List)((List)map.get("apis")));
        for (Map api : apis) {
            String operPath = (String)api.get("path");
            if (relativePath != null && operPath.startsWith(relativePath) && operPath.length() > relativePath.length()) {
                operPath = operPath.substring(relativePath.length());
            }
            List operations = CastUtils.cast((List)((List)api.get("operations")));
            for (Map oper : operations) {
                UserOperation userOp = new UserOperation();
                userOp.setPath(operPath);
                userOp.setName((String)oper.get("nickname"));
                userOp.setVerb((String)oper.get("method"));
                List opProduces = CastUtils.cast((List)((List)oper.get("produces")));
                userOp.setProduces(SwaggerUtils.listToString(opProduces));
                List opConsumes = CastUtils.cast((List)((List)oper.get("consumes")));
                userOp.setConsumes(SwaggerUtils.listToString(opConsumes));
                LinkedList<Parameter> userOpParams = new LinkedList<Parameter>();
                List params = CastUtils.cast((List)((List)oper.get("parameters")));
                for (Map param : params) {
                    String name = (String)param.get("name");
                    String paramType = (String)param.get("paramType");
                    ParameterType pType = "body".equals(paramType) ? ParameterType.REQUEST_BODY : ParameterType.valueOf((String)paramType.toUpperCase());
                    Parameter userParam = new Parameter(pType, name);
                    SwaggerUtils.setJavaType(userParam, (String)param.get("type"));
                    userOpParams.add(userParam);
                }
                if (!userOpParams.isEmpty()) {
                    userOp.setParameters(userOpParams);
                }
                userOps.add(userOp);
            }
        }
        ur.setOperations(userOps);
        return ur;
    }

    private static void setJavaType(Parameter userParam, String typeName) {
        String javaTypeName = SWAGGER_TYPE_MAP.get(typeName);
        if (javaTypeName != null) {
            try {
                userParam.setJavaType(ClassLoaderUtils.loadClass((String)javaTypeName, SwaggerUtils.class));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String listToString(List<String> list) {
        if (list != null) {
            StringBuilder sb = new StringBuilder();
            for (String s : list) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(s);
            }
            return sb.toString();
        }
        return null;
    }

    static {
        SWAGGER_TYPE_MAP.put("string", "String");
        SWAGGER_TYPE_MAP.put("integer", "long");
        SWAGGER_TYPE_MAP.put("float", "float");
        SWAGGER_TYPE_MAP.put("double", "double");
        SWAGGER_TYPE_MAP.put("int", "int");
        SWAGGER_TYPE_MAP.put("long", "long");
        SWAGGER_TYPE_MAP.put("byte", "byte");
        SWAGGER_TYPE_MAP.put("boolean", "boolean");
        SWAGGER_TYPE_MAP.put("date", "java.util.Date");
        SWAGGER_TYPE_MAP.put("dateTime", "java.util.Date");
        SWAGGER_TYPE_MAP.put("File", "java.io.InputStream");
        SWAGGER_TYPE_MAP.put("file", "java.io.InputStream");
    }
}

