/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.reactor.client;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.StreamSupport;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.reactor.client.ReactorInvoker;
import org.apache.cxf.jaxrs.reactor.client.ReactorUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorInvokerImpl
implements ReactorInvoker {
    private final WebClient webClient;
    private final ExecutorService executorService;

    ReactorInvokerImpl(WebClient webClient, ExecutorService executorService) {
        this.webClient = webClient;
        this.executorService = executorService;
    }

    @Override
    public Mono<Response> get() {
        return this.method("GET");
    }

    public <R> Mono<R> get(Class<R> responseType) {
        return this.method("GET", responseType);
    }

    @Override
    public <T> Flux<T> getFlux(Class<T> responseType) {
        return this.flux("GET", responseType);
    }

    public <R> Mono<R> get(GenericType<R> genericType) {
        return this.method("GET", genericType);
    }

    @Override
    public Mono<Response> put(Entity<?> entity) {
        return this.method("PUT", entity);
    }

    public <R> Mono<R> put(Entity<?> entity, Class<R> responseType) {
        return this.method("PUT", responseType);
    }

    @Override
    public <T> Flux<T> putFlux(Entity<?> entity, Class<T> responseType) {
        return this.flux("PUT", entity, responseType);
    }

    public <R> Mono<R> put(Entity<?> entity, GenericType<R> genericType) {
        return this.method("PUT", entity, genericType);
    }

    @Override
    public Mono<Response> post(Entity<?> entity) {
        return this.method("POST", entity);
    }

    public <R> Mono<R> post(Entity<?> entity, Class<R> responseType) {
        return this.method("POST", entity, responseType);
    }

    @Override
    public <T> Flux<T> postFlux(Entity<?> entity, Class<T> responseType) {
        return this.flux("POST", entity, responseType);
    }

    public <R> Mono<R> post(Entity<?> entity, GenericType<R> genericType) {
        return this.method("POST", entity, genericType);
    }

    @Override
    public Mono<Response> delete() {
        return this.method("DELETE");
    }

    public <R> Mono<R> delete(Class<R> responseType) {
        return this.method("DELETE", responseType);
    }

    @Override
    public <T> Flux<T> deleteFlux(Class<T> responseType) {
        return this.flux("DELETE", responseType);
    }

    public <R> Mono<R> delete(GenericType<R> genericType) {
        return this.method("DELETE", genericType);
    }

    @Override
    public Mono<Response> head() {
        return this.method("HEAD");
    }

    @Override
    public Mono<Response> options() {
        return this.method("OPTIONS");
    }

    public <R> Mono<R> options(Class<R> responseType) {
        return this.method("OPTIONS", responseType);
    }

    @Override
    public <T> Flux<T> optionsFlux(Class<T> responseType) {
        return this.flux("OPTIONS", responseType);
    }

    public <R> Mono<R> options(GenericType<R> genericType) {
        return this.method("OPTIONS", genericType);
    }

    @Override
    public Mono<Response> trace() {
        return this.method("TRACE");
    }

    public <R> Mono<R> trace(Class<R> responseType) {
        return this.method("TRACE", responseType);
    }

    @Override
    public <T> Flux<T> traceFlux(Class<T> responseType) {
        return this.flux("TRACE", responseType);
    }

    public <R> Mono<R> trace(GenericType<R> genericType) {
        return this.method("TRACE", genericType);
    }

    @Override
    public Mono<Response> method(String name) {
        return this.method(name, (Class<R>)Response.class);
    }

    public <R> Mono<R> method(String name, Class<R> responseType) {
        return this.mono(this.webClient.async().method(name, responseType));
    }

    public <R> Mono<R> method(String name, GenericType<R> genericType) {
        return this.mono(this.webClient.async().method(name, genericType));
    }

    @Override
    public Mono<Response> method(String name, Entity<?> entity) {
        return this.method(name, entity, (Class<R>)Response.class);
    }

    public <R> Mono<R> method(String name, Entity<?> entity, Class<R> responseType) {
        return this.mono(this.webClient.async().method(name, entity, responseType));
    }

    @Override
    public <T> Flux<T> flux(String name, Entity<?> entity, Class<T> responseType) {
        Future futureResponse = this.webClient.async().method(name, entity);
        return Flux.fromStream(() -> StreamSupport.stream(this.toIterable(futureResponse, responseType).spliterator(), false));
    }

    @Override
    public <T> Flux<T> flux(String name, Class<T> responseType) {
        Future futureResponse = this.webClient.async().method(name);
        return Flux.fromStream(() -> StreamSupport.stream(this.toIterable(futureResponse, responseType).spliterator(), false));
    }

    public <R> Mono<R> method(String name, Entity<?> entity, GenericType<R> genericType) {
        return this.mono(this.webClient.async().method(name, entity, genericType));
    }

    private <R> Mono<R> mono(Future<R> future) {
        return Mono.fromFuture(ReactorUtils.toCompletableFuture(future, this.executorService));
    }

    private <R> Iterable<R> toIterable(Future<Response> futureResponse, Class<R> type) {
        try {
            Response response = futureResponse.get();
            GenericType rGenericType = new GenericType(new WrappedType<R>(type));
            return (Iterable)response.readEntity(rGenericType);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new CompletionException(e);
        }
    }

    private class WrappedType<R>
    implements ParameterizedType {
        private final Class<R> rClass;

        WrappedType(Class<R> rClass) {
            this.rClass = rClass;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.rClass};
        }

        @Override
        public Type getRawType() {
            return List.class;
        }

        @Override
        public Type getOwnerType() {
            return List.class;
        }
    }
}

