/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.rx2.client;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.rx2.client.FlowableRxInvoker;

public class FlowableRxInvokerImpl
implements FlowableRxInvoker {
    private Scheduler sc;
    private WebClient wc;

    public FlowableRxInvokerImpl(WebClient wc, ExecutorService ex) {
        this.wc = wc;
        this.sc = ex == null ? null : Schedulers.from((Executor)ex);
    }

    @Override
    public Flowable<Response> get() {
        return this.get(Response.class);
    }

    @Override
    public <T> Flowable<T> get(Class<T> responseType) {
        return this.method("GET", responseType);
    }

    @Override
    public <T> Flowable<T> get(GenericType<T> responseType) {
        return this.method("GET", responseType);
    }

    @Override
    public Flowable<Response> put(Entity<?> entity) {
        return this.put(entity, Response.class);
    }

    @Override
    public <T> Flowable<T> put(Entity<?> entity, Class<T> responseType) {
        return this.method("PUT", entity, responseType);
    }

    @Override
    public <T> Flowable<T> put(Entity<?> entity, GenericType<T> responseType) {
        return this.method("PUT", entity, responseType);
    }

    @Override
    public Flowable<Response> post(Entity<?> entity) {
        return this.post(entity, Response.class);
    }

    @Override
    public <T> Flowable<T> post(Entity<?> entity, Class<T> responseType) {
        return this.method("POST", entity, responseType);
    }

    @Override
    public <T> Flowable<T> post(Entity<?> entity, GenericType<T> responseType) {
        return this.method("POST", entity, responseType);
    }

    @Override
    public Flowable<Response> delete() {
        return this.delete(Response.class);
    }

    @Override
    public <T> Flowable<T> delete(Class<T> responseType) {
        return this.method("DELETE", responseType);
    }

    @Override
    public <T> Flowable<T> delete(GenericType<T> responseType) {
        return this.method("DELETE", responseType);
    }

    @Override
    public Flowable<Response> head() {
        return this.method("HEAD");
    }

    @Override
    public Flowable<Response> options() {
        return this.options(Response.class);
    }

    @Override
    public <T> Flowable<T> options(Class<T> responseType) {
        return this.method("OPTIONS", responseType);
    }

    @Override
    public <T> Flowable<T> options(GenericType<T> responseType) {
        return this.method("OPTIONS", responseType);
    }

    @Override
    public Flowable<Response> trace() {
        return this.trace(Response.class);
    }

    @Override
    public <T> Flowable<T> trace(Class<T> responseType) {
        return this.method("TRACE", responseType);
    }

    @Override
    public <T> Flowable<T> trace(GenericType<T> responseType) {
        return this.method("TRACE", responseType);
    }

    @Override
    public Flowable<Response> method(String name) {
        return this.method(name, Response.class);
    }

    @Override
    public Flowable<Response> method(String name, Entity<?> entity) {
        return this.method(name, entity, Response.class);
    }

    @Override
    public <T> Flowable<T> method(String name, Entity<?> entity, Class<T> responseType) {
        if (this.sc == null) {
            return Flowable.fromFuture((Future)this.wc.async().method(name, entity, responseType));
        }
        return Flowable.fromFuture((Future)this.wc.async().method(name, entity, responseType), (Scheduler)this.sc);
    }

    @Override
    public <T> Flowable<T> method(String name, Entity<?> entity, GenericType<T> responseType) {
        if (this.sc == null) {
            return Flowable.fromFuture((Future)this.wc.async().method(name, entity, responseType));
        }
        return Flowable.fromFuture((Future)this.wc.async().method(name, entity, responseType), (Scheduler)this.sc);
    }

    @Override
    public <T> Flowable<T> method(String name, Class<T> responseType) {
        if (this.sc == null) {
            return Flowable.fromFuture((Future)this.wc.async().method(name, responseType));
        }
        return Flowable.fromFuture((Future)this.wc.async().method(name, responseType), (Scheduler)this.sc);
    }

    @Override
    public <T> Flowable<T> method(String name, GenericType<T> responseType) {
        if (this.sc == null) {
            return Flowable.fromFuture((Future)this.wc.async().method(name, responseType));
        }
        return Flowable.fromFuture((Future)this.wc.async().method(name, responseType), (Scheduler)this.sc);
    }
}

