/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.rx2.server;

import io.reactivex.Flowable;
import io.reactivex.Observable;
import io.reactivex.Single;
import io.reactivex.disposables.Disposable;
import javax.ws.rs.container.AsyncResponse;
import org.apache.cxf.jaxrs.impl.AsyncResponseImpl;
import org.apache.cxf.jaxrs.reactivestreams.server.AbstractReactiveInvoker;
import org.apache.cxf.message.Message;
import org.reactivestreams.Publisher;

public class ReactiveIOInvoker
extends AbstractReactiveInvoker {
    protected AsyncResponseImpl checkFutureResponse(Message inMessage, Object result) {
        if (result instanceof Flowable) {
            return this.handleFlowable(inMessage, (Flowable)result);
        }
        if (result instanceof Single) {
            return this.handleSingle(inMessage, (Single)result);
        }
        if (result instanceof Observable) {
            return this.handleObservable(inMessage, (Observable)result);
        }
        return null;
    }

    protected AsyncResponseImpl handleSingle(Message inMessage, Single<?> single) {
        AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
        Disposable d = single.subscribe(arg_0 -> ((AsyncResponseImpl)asyncResponse).resume(arg_0), t -> this.handleThrowable(asyncResponse, (Throwable)t));
        if (d == null) {
            throw new IllegalStateException("Subscribe did not return a Disposable");
        }
        return asyncResponse;
    }

    protected AsyncResponseImpl handleFlowable(Message inMessage, Flowable<?> f) {
        AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
        if (!this.isStreamingSubscriberUsed((Publisher)f, (AsyncResponse)asyncResponse, inMessage)) {
            Disposable d = f.subscribe(arg_0 -> ((AsyncResponseImpl)asyncResponse).resume(arg_0), t -> this.handleThrowable(asyncResponse, (Throwable)t));
            if (d == null) {
                throw new IllegalStateException("Subscribe did not return a Disposable");
            }
        }
        return asyncResponse;
    }

    protected AsyncResponseImpl handleObservable(Message inMessage, Observable<?> obs) {
        AsyncResponseImpl asyncResponse = new AsyncResponseImpl(inMessage);
        Disposable d = obs.subscribe(v -> asyncResponse.resume(v), t -> this.handleThrowable(asyncResponse, (Throwable)t));
        if (d == null) {
            throw new IllegalStateException("Subscribe did not return a Disposable");
        }
        return asyncResponse;
    }
}

