/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractUntypedSearchConditionVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLPrinterVisitor<T>
extends AbstractUntypedSearchConditionVisitor<T, String> {
    private String table;
    private String tableAlias;
    private List<String> columns;

    public SQLPrinterVisitor() {
        this(null, null, Collections.emptyList());
    }

    public SQLPrinterVisitor(String table, String ... columns) {
        this(null, table, Arrays.asList(columns));
    }

    public SQLPrinterVisitor(Map<String, String> fieldMap, String table, List<String> columns) {
        this(fieldMap, table, null, columns);
    }

    public SQLPrinterVisitor(Map<String, String> fieldMap, String table, String tableAlias, List<String> columns) {
        super(fieldMap);
        this.columns = columns;
        this.table = table;
        this.tableAlias = tableAlias;
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        StringBuilder sb = this.getStringBuilder();
        PrimitiveStatement statement = sc.getStatement();
        if (statement != null) {
            if (statement.getProperty() != null) {
                String name = this.getRealPropertyName(statement.getProperty());
                String value = this.getPropertyValue(name, statement.getValue());
                this.validatePropertyValue(name, value);
                String rvalStr = value.replaceAll("\\*", "%");
                if (this.tableAlias != null) {
                    name = this.tableAlias + "." + name;
                }
                sb.append(name).append(" ").append(SearchUtils.conditionTypeToSqlOperator(sc.getConditionType(), rvalStr)).append(" ").append("'").append(rvalStr).append("'");
            }
        } else {
            boolean first = true;
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                if (!first) {
                    sb.append(" ").append(sc.getConditionType().toString()).append(" ");
                } else {
                    first = false;
                }
                sb.append("(");
                this.saveStringBuilder(sb);
                condition.accept(this);
                sb = this.getStringBuilder();
                sb.append(")");
            }
        }
        this.saveStringBuilder(sb);
    }

    @Override
    protected StringBuilder getStringBuilder() {
        StringBuilder sb = super.getStringBuilder();
        if (sb == null) {
            sb = new StringBuilder();
            if (this.table != null) {
                SearchUtils.startSqlQuery(sb, this.table, this.tableAlias, this.columns);
            }
        }
        return sb;
    }
}

