/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.ldap;

import java.util.Collections;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.ldap.Util;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractUntypedSearchConditionVisitor;

public class LdapQueryVisitor<T>
extends AbstractUntypedSearchConditionVisitor<T, String> {
    private boolean encodeQueryValues = true;

    public LdapQueryVisitor() {
        this(Collections.emptyMap());
    }

    public LdapQueryVisitor(Map<String, String> fieldMap) {
        super(fieldMap);
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement;
        StringBuilder sb = this.getStringBuilder();
        if (sb == null) {
            sb = new StringBuilder();
        }
        if ((statement = sc.getStatement()) != null) {
            if (statement.getProperty() != null) {
                String name = this.getRealPropertyName(statement.getProperty());
                String rvalStr = this.getPropertyValue(name, statement.getValue());
                this.validatePropertyValue(name, rvalStr);
                sb.append("(");
                if (sc.getConditionType() == ConditionType.NOT_EQUALS) {
                    sb.append("!");
                }
                String ldapOperator = LdapQueryVisitor.conditionTypeToLdapOperator(sc.getConditionType());
                String encodedRValStr = this.encodeQueryValues ? Util.doRFC2254Encoding(rvalStr) : rvalStr;
                sb.append(name).append(ldapOperator).append(encodedRValStr);
                sb.append(")");
            }
        } else {
            sb.append("(");
            if (sc.getConditionType() == ConditionType.AND) {
                sb.append("&");
            } else {
                sb.append("|");
            }
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                this.saveStringBuilder(sb);
                condition.accept(this);
                sb = this.getStringBuilder();
            }
            sb.append(")");
        }
        this.saveStringBuilder(sb);
    }

    public static String conditionTypeToLdapOperator(ConditionType ct) {
        String op;
        switch (ct) {
            case EQUALS: 
            case NOT_EQUALS: {
                op = "=";
                break;
            }
            case GREATER_THAN: 
            case GREATER_OR_EQUALS: {
                op = ">=";
                break;
            }
            case LESS_THAN: 
            case LESS_OR_EQUALS: {
                op = "<=";
                break;
            }
            default: {
                String msg = String.format("Condition type %s is not supported", ct.name());
                throw new RuntimeException(msg);
            }
        }
        return op;
    }

    public boolean isEncodeQueryValues() {
        return this.encodeQueryValues;
    }

    public void setEncodeQueryValues(boolean encodeQueryValues) {
        this.encodeQueryValues = encodeQueryValues;
    }
}

