/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.json.basic;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;

public class JsonMapObject
implements Serializable {
    private static final long serialVersionUID = 2620765136328623790L;
    Map<String, Integer> updateCount;
    Map<String, Object> values = new LinkedHashMap<String, Object>();

    public JsonMapObject() {
    }

    public JsonMapObject(Map<String, Object> values) {
        this.values = values;
    }

    public void setProperty(String name, Object value) {
        if (this.values.containsKey(name)) {
            int n;
            Integer count;
            if (this.updateCount == null) {
                this.updateCount = new LinkedHashMap<String, Integer>();
            }
            if ((count = this.updateCount.get(name)) == null) {
                n = 2;
            } else {
                Integer n2 = count;
                Integer n3 = count = Integer.valueOf(count + 1);
                n = n2;
            }
            count = n;
            this.updateCount.put(name, count);
        }
        this.values.put(name, value);
    }

    public boolean containsProperty(String name) {
        return this.values.containsKey(name);
    }

    public Object getProperty(String name) {
        return this.values.get(name);
    }

    public Map<String, Object> getMapProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return CastUtils.cast((Map)((Map)value));
        }
        return null;
    }

    public Map<String, Object> asMap() {
        return this.values;
    }

    public Integer getIntegerProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
        }
        return null;
    }

    public Long getLongProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value instanceof Long ? (Long)value : Long.parseLong(value.toString());
        }
        return null;
    }

    public Boolean getBooleanProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
        }
        return null;
    }

    public String getStringProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    public List<String> getListStringProperty(String name) {
        Object value = this.getProperty(name);
        if (value != null) {
            return CastUtils.cast((List)((List)value));
        }
        return null;
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JsonMapObject && ((JsonMapObject)obj).values.equals(this.values);
    }

    public Map<String, Object> getUpdateCount() {
        return this.updateCount == null ? null : Collections.unmodifiableMap(this.updateCount);
    }

    public Object removeProperty(String name) {
        return this.values.remove(name);
    }
}

