/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.microprofile.client.MPRestClientCallback;
import org.apache.cxf.microprofile.client.MicroProfileClientProviderFactory;
import org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorImpl;
import org.apache.cxf.microprofile.client.proxy.MPAsyncInvocationInterceptorPostAsyncImpl;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

public class MicroProfileClientProxyImpl
extends ClientProxyImpl {
    private static final InvocationCallback<Object> NO_OP_CALLBACK = new InvocationCallback<Object>(){

        public void failed(Throwable t) {
        }

        public void completed(Object o) {
        }
    };
    private final MPAsyncInvocationInterceptorImpl aiiImpl = new MPAsyncInvocationInterceptorImpl();

    public MicroProfileClientProxyImpl(URI baseURI, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, ExecutorService executorService, Configuration configuration, Object ... varValues) {
        super((ClientState)new LocalClientState(baseURI, configuration.getProperties()), loader, cri, isRoot, inheritHeaders, varValues);
        this.cfg.getRequestContext().put("executorService", executorService);
        this.cfg.getRequestContext().putAll(configuration.getProperties());
    }

    public MicroProfileClientProxyImpl(ClientState initialState, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, ExecutorService executorService, Configuration configuration, Object ... varValues) {
        super(initialState, loader, cri, isRoot, inheritHeaders, varValues);
        this.cfg.getRequestContext().put("executorService", executorService);
        this.cfg.getRequestContext().putAll(configuration.getProperties());
    }

    protected InvocationCallback<Object> checkAsyncCallback(OperationResourceInfo ori, Map<String, Object> reqContext, Message outMessage) {
        InvocationCallback<Object> callback = (InvocationCallback<Object>)outMessage.getContent(InvocationCallback.class);
        if (callback == null && CompletionStage.class.equals(ori.getMethodToInvoke().getReturnType())) {
            callback = NO_OP_CALLBACK;
            outMessage.setContent(InvocationCallback.class, callback);
        }
        return callback;
    }

    protected boolean checkAsyncReturnType(OperationResourceInfo ori, Map<String, Object> reqContext, Message outMessage) {
        return CompletionStage.class.equals(ori.getMethodToInvoke().getReturnType());
    }

    protected Object doInvokeAsync(OperationResourceInfo ori, Message outMessage, InvocationCallback<Object> asyncCallback) {
        outMessage.getInterceptorChain().add((Interceptor)this.aiiImpl);
        this.cfg.getInInterceptors().add(new MPAsyncInvocationInterceptorPostAsyncImpl(this.aiiImpl.getInterceptors()));
        super.doInvokeAsync(ori, outMessage, asyncCallback);
        JaxrsClientCallback cb = (JaxrsClientCallback)outMessage.getExchange().get(JaxrsClientCallback.class);
        return cb.createFuture();
    }

    protected JaxrsClientCallback<?> newJaxrsClientCallback(InvocationCallback<Object> asyncCallback, Class<?> responseClass, Type outGenericType) {
        return new MPRestClientCallback<Object>(asyncCallback, responseClass, outGenericType);
    }

    protected void checkResponse(Method m, Response r, Message inMessage) throws Throwable {
        MicroProfileClientProviderFactory factory = MicroProfileClientProviderFactory.getInstance(inMessage);
        List<ResponseExceptionMapper<?>> mappers = factory.createResponseExceptionMapper(inMessage, Throwable.class);
        for (ResponseExceptionMapper<?> mapper : mappers) {
            if (!mapper.handles(r.getStatus(), r.getHeaders())) continue;
            Throwable t = mapper.toThrowable(r);
            if (t instanceof RuntimeException) {
                throw t;
            }
            if (t == null || m.getExceptionTypes() == null) continue;
            for (Class<?> c : m.getExceptionTypes()) {
                if (!t.getClass().isAssignableFrom(c)) continue;
                throw t;
            }
        }
    }

    protected Class<?> getReturnType(Method method, Message outMessage) {
        Class returnType = super.getReturnType(method, outMessage);
        if (CompletionStage.class.isAssignableFrom(returnType)) {
            Type t = method.getGenericReturnType();
            returnType = InjectionUtils.getActualType((Type)t);
        }
        return returnType;
    }

    protected Message createMessage(Object body, OperationResourceInfo ori, MultivaluedMap<String, String> headers, URI currentURI, Exchange exchange, Map<String, Object> invocationContext, boolean proxy) {
        Method m = ori.getMethodToInvoke();
        Message msg = super.createMessage(body, ori, headers, currentURI, exchange, invocationContext, proxy);
        HashMap<String, Method> filterProps = (HashMap<String, Method>)msg.getExchange().get((Object)"jaxrs.filter.properties");
        if (filterProps == null) {
            filterProps = new HashMap<String, Method>();
            msg.getExchange().put((Object)"jaxrs.filter.properties", filterProps);
        }
        filterProps.put("org.eclipse.microprofile.rest.client.invokedMethod", m);
        return msg;
    }
}

