/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Configuration;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.ClientProxyImpl;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.FilterProviderInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.jsrjsonp.JsrJsonpProvider;
import org.apache.cxf.microprofile.client.DefaultResponseExceptionMapper;
import org.apache.cxf.microprofile.client.MicroProfileClientConfigurableImpl;
import org.apache.cxf.microprofile.client.MicroProfileClientProviderFactory;
import org.apache.cxf.microprofile.client.proxy.MicroProfileClientProxyImpl;
import org.eclipse.microprofile.rest.client.RestClientBuilder;

public class MicroProfileClientFactoryBean
extends JAXRSClientFactoryBean {
    private final Comparator<ProviderInfo<?>> comparator;
    private final List<Object> registeredProviders;
    private Configuration configuration;
    private ClassLoader proxyLoader;
    private boolean inheritHeaders;
    private ExecutorService executorService;

    public MicroProfileClientFactoryBean(MicroProfileClientConfigurableImpl<RestClientBuilder> configuration, String baseUri, Class<?> aClass, ExecutorService executorService) {
        this.configuration = configuration.getConfiguration();
        this.comparator = MicroProfileClientProviderFactory.createComparator(this);
        this.executorService = executorService;
        super.setAddress(baseUri);
        super.setServiceClass(aClass);
        super.setProviderComparator(this.comparator);
        this.registeredProviders = new ArrayList<Object>();
        this.registeredProviders.addAll(this.processProviders());
        if (!configuration.isDefaultExceptionMapperDisabled()) {
            this.registeredProviders.add(new ProviderInfo((Object)new DefaultResponseExceptionMapper(), this.getBus(), false));
        }
        this.registeredProviders.add(new ProviderInfo((Object)new JsrJsonpProvider(), this.getBus(), false));
        super.setProviders(this.registeredProviders);
    }

    public void setClassLoader(ClassLoader loader) {
        super.setClassLoader(loader);
        this.proxyLoader = loader;
    }

    public void setInheritHeaders(boolean inheritHeaders) {
        super.setInheritHeaders(inheritHeaders);
        this.inheritHeaders = inheritHeaders;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    protected void initClient(AbstractClient client, Endpoint ep, boolean addHeaders) {
        super.initClient(client, ep, addHeaders);
        MicroProfileClientProviderFactory factory = MicroProfileClientProviderFactory.createInstance(this.getBus(), this.comparator);
        factory.setUserProviders(this.registeredProviders);
        ep.put((Object)MicroProfileClientProviderFactory.CLIENT_FACTORY_NAME, (Object)factory);
    }

    protected ClientProxyImpl createClientProxy(ClassResourceInfo cri, boolean isRoot, ClientState actualState, Object[] varValues) {
        if (actualState == null) {
            return new MicroProfileClientProxyImpl(URI.create(this.getAddress()), this.proxyLoader, cri, isRoot, this.inheritHeaders, this.executorService, varValues);
        }
        return new MicroProfileClientProxyImpl(actualState, this.proxyLoader, cri, isRoot, this.inheritHeaders, this.executorService, varValues);
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    private Set<Object> processProviders() {
        LinkedHashSet<Object> providers = new LinkedHashSet<Object>();
        for (Object provider : this.configuration.getInstances()) {
            Class providerCls = ClassHelper.getRealClass((Bus)this.bus, provider);
            if (provider instanceof ClientRequestFilter || provider instanceof ClientResponseFilter) {
                FilterProviderInfo filter = new FilterProviderInfo(providerCls, providerCls, provider, this.bus, this.configuration.getContracts(providerCls));
                providers.add(filter);
                continue;
            }
            providers.add(provider);
        }
        return providers;
    }
}

