/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.microprofile.client.CxfTypeSafeClientBuilder;
import org.apache.cxf.microprofile.client.config.ConfigFacade;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;

public class RestClientBean
implements Bean<Object>,
PassivationCapable {
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_URI_FORMAT = "%s/mp-rest/uri";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    public static final String REST_PROVIDERS_FORMAT = "%s/mp-rest/providers";
    public static final String REST_PROVIDERS_PRIORITY_FORMAT = "%s/mp-rest/providers/%s/priority";
    private static final Logger LOG = LogUtils.getL7dLogger(RestClientBean.class);
    private static final Default DEFAULT_LITERAL = new DefaultLiteral();
    private final Class<?> clientInterface;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;

    public RestClientBean(Class<?> clientInterface, BeanManager beanManager) {
        this.clientInterface = clientInterface;
        this.beanManager = beanManager;
        this.scope = this.readScope();
    }

    public String getId() {
        return this.clientInterface.getName();
    }

    public Class<?> getBeanClass() {
        return this.clientInterface;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        CxfTypeSafeClientBuilder builder = new CxfTypeSafeClientBuilder();
        String baseUri = this.getBaseUri();
        builder = builder.baseUri(URI.create(baseUri));
        List<Class<?>> providers = this.getConfiguredProviders();
        Map<Class<?>, Integer> providerPriorities = this.getConfiguredProviderPriorities(providers);
        for (Class<?> providerClass : providers) {
            builder = (RestClientBuilder)builder.register(providerClass, providerPriorities.getOrDefault(providerClass, 5000));
        }
        return builder.build(this.clientInterface);
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.clientInterface);
    }

    public Set<Annotation> getQualifiers() {
        return new HashSet<Annotation>(Arrays.asList(DEFAULT_LITERAL, RestClient.RestClientLiteral.LITERAL));
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.clientInterface.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    private String getBaseUri() {
        String interfaceName = this.clientInterface.getName();
        String property = String.format(REST_URI_FORMAT, interfaceName);
        String baseURI = null;
        try {
            baseURI = ConfigFacade.getValue(property, String.class);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (baseURI == null && (baseURI = ConfigFacade.getValue(property = String.format(REST_URL_FORMAT, interfaceName), String.class)) == null) {
            throw new IllegalStateException("Unable to determine base URI from configuration");
        }
        return baseURI;
    }

    private Class<? extends Annotation> readScope() {
        Annotation[] annotations;
        String property = String.format(REST_SCOPE_FORMAT, this.clientInterface.getName());
        String configuredScope = ConfigFacade.getOptionalValue(property, String.class).orElse(null);
        if (configuredScope != null) {
            try {
                return ClassLoaderUtils.loadClass((String)configuredScope, this.getClass(), Annotation.class);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("The scope " + configuredScope + " is invalid", e);
            }
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.clientInterface.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        throw new IllegalArgumentException("The client interface " + this.clientInterface + " has multiple scopes defined " + possibleScopes);
    }

    List<Class<?>> getConfiguredProviders() {
        String property = String.format(REST_PROVIDERS_FORMAT, this.clientInterface.getName());
        String providersList = ConfigFacade.getOptionalValue(property, String.class).orElse("");
        String[] providerClassNames = providersList.split(",");
        ArrayList providers = new ArrayList();
        for (int i = 0; i < providerClassNames.length; ++i) {
            try {
                providers.add(ClassLoaderUtils.loadClass((String)providerClassNames[i], RestClientBean.class));
                continue;
            }
            catch (ClassNotFoundException e) {
                LOG.log(Level.WARNING, "Could not load provider, {0}, configured for Rest Client interface, {1} ", new Object[]{providerClassNames[i], this.clientInterface.getName()});
            }
        }
        return providers;
    }

    Map<Class<?>, Integer> getConfiguredProviderPriorities(List<Class<?>> providers) {
        HashMap map = new HashMap();
        for (Class<?> providerClass : providers) {
            String property = String.format(REST_PROVIDERS_PRIORITY_FORMAT, this.clientInterface.getName(), providerClass.getName());
            Integer priority = ConfigFacade.getOptionalValue(property, Integer.class).orElse(RestClientBean.getPriorityFromClass(providerClass, 5000));
            map.put(providerClass, priority);
        }
        return map;
    }

    private static int getPriorityFromClass(Class<?> providerClass, int defaultValue) {
        Priority p = providerClass.getAnnotation(Priority.class);
        return p != null ? p.value() : defaultValue;
    }

    private static final class DefaultLiteral
    extends AnnotationLiteral<Default>
    implements Default {
        private static final long serialVersionUID = 1L;

        private DefaultLiteral() {
        }
    }
}

