/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.ws.rs.client.InvocationCallback;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;

public class MPRestClientCallback<T>
extends JaxrsClientCallback<T> {
    public MPRestClientCallback(InvocationCallback<T> handler, Class<?> responseClass, Type outGenericType) {
        super(handler, responseClass, outGenericType);
    }

    public Future<T> createFuture() {
        return new MPRestClientResponseFuture(this);
    }

    static class MPRestClientResponseFuture<T>
    extends CompletableFuture<T>
    implements Future<T> {
        MPRestClientCallback<T> callback;

        MPRestClientResponseFuture(MPRestClientCallback<T> cb) {
            this.callback = cb;
        }

        public Map<String, Object> getContext() {
            try {
                return this.callback.getResponseContext();
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.callback.cancel(mayInterruptIfRunning);
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                return this.getObject(this.callback.get()[0]);
            }
            catch (InterruptedException ex) {
                InvocationCallback handler = this.callback.getHandler();
                if (handler != null) {
                    handler.failed((Throwable)ex);
                }
                throw ex;
            }
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                return this.getObject(this.callback.get(timeout, unit)[0]);
            }
            catch (InterruptedException ex) {
                InvocationCallback handler = this.callback.getHandler();
                if (handler != null) {
                    handler.failed((Throwable)ex);
                }
                throw ex;
            }
        }

        private T getObject(Object object) {
            return (T)object;
        }

        @Override
        public boolean isCancelled() {
            return this.callback.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.callback.isDone();
        }
    }
}

