/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.microprofile.client.config;

import java.util.Optional;
import java.util.OptionalLong;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class ConfigFacade {
    private ConfigFacade() {
    }

    private static Optional<Config> config() {
        Config c;
        try {
            c = ConfigProvider.getConfig();
        }
        catch (ExceptionInInitializerError | IllegalStateException | NoClassDefFoundError ex) {
            c = null;
        }
        return Optional.ofNullable(c);
    }

    public static <T> Optional<T> getOptionalValue(String propertyName, Class<T> clazz) {
        Optional<Config> c = ConfigFacade.config();
        return c.isPresent() ? c.get().getOptionalValue(propertyName, clazz) : Optional.empty();
    }

    public static <T> T getValue(String propertyName, Class<T> clazz) {
        Optional<Config> c = ConfigFacade.config();
        return (T)(c.isPresent() ? c.get().getValue(propertyName, clazz) : null);
    }

    public static OptionalLong getOptionalLong(String propName) {
        Optional<Config> c = ConfigFacade.config();
        Optional opt = c.isPresent() ? c.get().getOptionalValue(propName, Long.class) : Optional.empty();
        return opt.isPresent() ? OptionalLong.of((Long)opt.get()) : OptionalLong.empty();
    }
}

