/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature;

import java.io.IOException;
import java.security.PrivateKey;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.cxf.rs.security.httpsignature.SignatureCreator;
import org.apache.cxf.rs.security.httpsignature.TomitribeSignatureCreator;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;

public class MessageSigner {
    private final String digestAlgorithmName;
    private SignatureCreator signatureCreator;

    public MessageSigner(String signatureAlgorithmName, String digestAlgorithmName, PrivateKey privateKey, String keyId) {
        this.digestAlgorithmName = Objects.requireNonNull(digestAlgorithmName);
        this.signatureCreator = new TomitribeSignatureCreator(Objects.requireNonNull(signatureAlgorithmName), Objects.requireNonNull(privateKey), Objects.requireNonNull(keyId));
    }

    public MessageSigner(PrivateKey privateKey, String keyId) {
        this("rsa-sha256", "SHA-256", privateKey, keyId);
    }

    public void sign(Map<String, List<String>> messageHeaders, String uri, String method) throws IOException {
        SignatureHeaderUtils.inspectMessageHeaders(messageHeaders);
        Objects.requireNonNull(uri);
        Objects.requireNonNull(method);
        messageHeaders.put("Signature", Collections.singletonList(this.signatureCreator.createSignature(messageHeaders, uri, method)));
    }

    public void sign(Map<String, List<String>> messageHeaders, String uri, String method, String messageBody) throws IOException {
        SignatureHeaderUtils.inspectMessageHeaders(messageHeaders);
        Objects.requireNonNull(uri);
        Objects.requireNonNull(method);
        Objects.requireNonNull(messageBody);
        messageHeaders.put("Digest", Collections.singletonList(SignatureHeaderUtils.createDigestHeader(messageBody, this.digestAlgorithmName)));
        messageHeaders.put("Signature", Collections.singletonList(this.signatureCreator.createSignature(messageHeaders, uri, method)));
    }
}

