/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature;

import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.httpsignature.SignatureValidator;
import org.apache.cxf.rs.security.httpsignature.exception.DifferentAlgorithmsException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidDataToVerifySignatureException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidSignatureException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.provider.AlgorithmProvider;
import org.apache.cxf.rs.security.httpsignature.provider.PublicKeyProvider;
import org.apache.cxf.rs.security.httpsignature.provider.SecurityProvider;
import org.apache.cxf.rs.security.httpsignature.utils.SignatureHeaderUtils;
import org.tomitribe.auth.signatures.Signature;
import org.tomitribe.auth.signatures.Verifier;

public class TomitribeSignatureValidator
implements SignatureValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(TomitribeSignatureValidator.class);

    @Override
    public void validate(Map<String, List<String>> messageHeaders, AlgorithmProvider algorithmProvider, PublicKeyProvider publicKeyProvider, SecurityProvider securityProvider, String method, String uri) {
        String signatureAlgorithm;
        Signature signature = TomitribeSignatureValidator.extractSignatureFromHeader(messageHeaders.get("Signature").get(0));
        String providedAlgorithm = algorithmProvider.getAlgorithmName(signature.getKeyId());
        if (!providedAlgorithm.equals(signatureAlgorithm = signature.getAlgorithm().toString())) {
            throw new DifferentAlgorithmsException("signature algorithm from header and provided are different");
        }
        PublicKey key = publicKeyProvider.getKey(signature.getKeyId());
        Provider provider = securityProvider.getProvider(signature.getKeyId());
        this.runVerifier(messageHeaders, key, signature, provider, method, uri);
    }

    private static Signature extractSignatureFromHeader(String signatureString) {
        try {
            return Signature.fromString((String)signatureString);
        }
        catch (Exception e) {
            throw new InvalidSignatureHeaderException("failed to parse signature from header", e);
        }
    }

    private void runVerifier(Map<String, List<String>> messageHeaders, Key key, Signature signature, Provider provider, String method, String uri) {
        boolean success;
        Verifier verifier = new Verifier(key, signature, provider);
        LOG.fine("Starting signature validation");
        try {
            success = verifier.verify(method, uri, SignatureHeaderUtils.mapHeaders(messageHeaders));
        }
        catch (Exception e) {
            throw new InvalidDataToVerifySignatureException(e.getMessage(), e);
        }
        if (!success) {
            throw new InvalidSignatureException("signature is not valid");
        }
        LOG.fine("Finished signature validation");
    }
}

