/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.filters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.ReaderInterceptor;
import javax.ws.rs.ext.ReaderInterceptorContext;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.rs.security.httpsignature.DigestVerifier;
import org.apache.cxf.rs.security.httpsignature.exception.DigestFailureException;

@Provider
@Priority(value=1000)
public final class VerifyDigestInterceptor
implements ReaderInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(VerifyDigestInterceptor.class);
    private DigestVerifier digestVerifier;
    private boolean enabled;

    public VerifyDigestInterceptor() {
        this.setEnabled(true);
        this.setDigestVerifier(new DigestVerifier());
    }

    public Object aroundReadFrom(ReaderInterceptorContext context) throws IOException, WebApplicationException {
        if (!this.enabled) {
            LOG.fine("Verify signature reader interceptor is disabled");
            return context.proceed();
        }
        LOG.fine("Starting interceptor message verification process");
        MultivaluedMap responseHeaders = context.getHeaders();
        byte[] messageBody = this.extractMessageBody(context);
        this.digestVerifier.inspectDigest(messageBody, (Map<String, List<String>>)responseHeaders);
        context.setInputStream((InputStream)new ByteArrayInputStream(messageBody));
        LOG.fine("Finished interceptor message verification process");
        return context.proceed();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public DigestVerifier getDigestVerifier() {
        return this.digestVerifier;
    }

    public void setDigestVerifier(DigestVerifier digestVerifier) {
        Objects.requireNonNull(digestVerifier);
        this.digestVerifier = digestVerifier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] extractMessageBody(ReaderInterceptorContext context) {
        try (InputStream is = context.getInputStream();){
            byte[] byArray = IOUtils.readBytesFromStream((InputStream)is);
            return byArray;
        }
        catch (IOException e) {
            throw new DigestFailureException("failed to validate the digest", e);
        }
    }
}

