/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.filters;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.annotation.Priority;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.rs.security.httpsignature.MessageVerifier;
import org.apache.cxf.rs.security.httpsignature.exception.DifferentAlgorithmsException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidDataToVerifySignatureException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidSignatureException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.exception.MissingSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.exception.MultipleSignatureHeaderException;

@Provider
@PreMatching
@Priority(value=1000)
public final class VerifySignatureFilter
implements ContainerRequestFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(VerifySignatureFilter.class);
    private MessageVerifier messageVerifier;
    private boolean enabled;

    public VerifySignatureFilter() {
        this.setEnabled(true);
    }

    public void filter(ContainerRequestContext requestCtx) {
        if (!this.enabled) {
            LOG.fine("Verify signature filter is disabled");
            return;
        }
        if (this.messageVerifier == null) {
            LOG.warning("Message verifier cannot be null");
            return;
        }
        LOG.fine("Starting filter message verification process");
        MultivaluedMap responseHeaders = requestCtx.getHeaders();
        try {
            this.messageVerifier.verifyMessage((Map<String, List<String>>)responseHeaders, requestCtx.getMethod(), requestCtx.getUriInfo().getAbsolutePath().getPath());
        }
        catch (DifferentAlgorithmsException | InvalidDataToVerifySignatureException | InvalidSignatureException | InvalidSignatureHeaderException | MissingSignatureHeaderException | MultipleSignatureHeaderException ex) {
            LOG.warning(ex.getMessage());
            throw new BadRequestException((Throwable)ex);
        }
        LOG.fine("Finished filter message verification process");
    }

    public void setMessageVerifier(MessageVerifier messageVerifier) {
        Objects.requireNonNull(messageVerifier);
        this.messageVerifier = messageVerifier;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

