/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.cxf.rs.security.httpsignature.exception.DigestFailureException;

public final class SignatureHeaderUtils {
    private SignatureHeaderUtils() {
    }

    public static void addDateHeader(Map<String, List<String>> messageHeaders, ZoneOffset zoneOffset) {
        String date = DateTimeFormatter.RFC_1123_DATE_TIME.format(LocalDateTime.now().atZone(Clock.system(zoneOffset).getZone()));
        messageHeaders.put("Date", Collections.singletonList(date));
    }

    public static Map<String, String> mapHeaders(Map<String, List<String>> multivaluedMap) {
        HashMap<String, String> mappedStrings = new HashMap<String, String>(multivaluedMap.size());
        for (Map.Entry<String, List<String>> entry : multivaluedMap.entrySet()) {
            mappedStrings.put(entry.getKey(), String.join((CharSequence)", ", (Iterable<? extends CharSequence>)entry.getValue()));
        }
        return mappedStrings;
    }

    public static String createDigestHeader(String messageBody, String digestAlgorithmName) {
        MessageDigest messageDigest = SignatureHeaderUtils.createMessageDigestWithAlgorithm(digestAlgorithmName);
        messageDigest.update(messageBody.getBytes());
        String digest = Base64.getEncoder().encodeToString(messageDigest.digest());
        StringBuilder sb = new StringBuilder(digestAlgorithmName.length() + 1 + digest.length());
        sb.append(digestAlgorithmName).append('=').append(digest);
        return sb.toString();
    }

    public static MessageDigest createMessageDigestWithAlgorithm(String algorithmName) {
        try {
            String foundAlgorithm = Stream.of("SHA-256", "SHA-512").filter(s -> s.equalsIgnoreCase(algorithmName)).findAny().orElseThrow(() -> new NoSuchAlgorithmException("found no match in digest algorithm allow-list"));
            return MessageDigest.getInstance(foundAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestFailureException("failed to retrieve digest from digest string", e);
        }
    }

    public static void inspectMessageHeaders(Map<String, List<String>> messageHeaders) {
        Objects.requireNonNull(messageHeaders);
        if (messageHeaders.isEmpty()) {
            throw new IllegalStateException("message headers are empty");
        }
        messageHeaders.forEach((key, list) -> {
            Objects.requireNonNull(list);
            list.forEach(Objects::requireNonNull);
        });
    }
}

