/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsJsonProducer;

public class AbstractJweJsonWriterProvider {
    protected static final Logger LOG = LogUtils.getL7dLogger(AbstractJweJsonWriterProvider.class);
    private List<JweEncryptionProvider> encProviders;

    public void setEncryptionProvider(JweEncryptionProvider provider) {
        this.setEncryptionProviders(Collections.singletonList(provider));
    }

    public void setEncryptionProviders(List<JweEncryptionProvider> providers) {
        this.encProviders = providers;
    }

    protected List<JweEncryptionProvider> getInitializedEncryptionProviders() {
        if (this.encProviders != null) {
            return this.encProviders;
        }
        Message m = JAXRSUtils.getCurrentMessage();
        Object propLocsProp = MessageUtils.getContextualProperty((Message)m, (String)"rs.security.encryption.out.properties", (String)"rs.security.encryption.properties");
        if (propLocsProp == null) {
            LOG.warning("JWE JSON init properties resource is not identified");
            throw new JwsException(JwsException.Error.NO_INIT_PROPERTIES);
        }
        List<String> propLocs = null;
        if (propLocsProp instanceof String) {
            String[] props = ((String)propLocsProp).split(",");
            propLocs = Arrays.asList(props);
        } else {
            propLocs = CastUtils.cast((List)((List)propLocsProp));
        }
        LinkedList<JweEncryptionProvider> theEncProviders = new LinkedList<JweEncryptionProvider>();
        for (String propLoc : propLocs) {
            theEncProviders.addAll(JweUtils.loadJweEncryptionProviders((String)propLoc, (Message)m));
        }
        return theEncProviders;
    }

    protected void writeJws(JwsJsonProducer p, OutputStream os) throws IOException {
        byte[] bytes = StringUtils.toBytesUTF8((String)p.getJwsJsonSignedDocument());
        IOUtils.copy((InputStream)new ByteArrayInputStream(bytes), (OutputStream)os);
    }
}

