/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartInputFilter;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.common.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsInputStream;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.JwsVerificationSignature;

public class JwsMultipartSignatureInFilter
implements MultipartInputFilter {
    private JsonMapObjectReaderWriter reader = new JsonMapObjectReaderWriter();
    private JwsSignatureVerifier verifier;
    private boolean bufferPayload;
    private Message message;
    private boolean useJwsJsonSignatureFormat;

    public JwsMultipartSignatureInFilter(Message message, JwsSignatureVerifier verifier, boolean bufferPayload, boolean useJwsJsonSignatureFormat) {
        this.message = message;
        this.verifier = verifier;
        this.bufferPayload = bufferPayload;
        this.useJwsJsonSignatureFormat = useJwsJsonSignatureFormat;
    }

    public void filter(List<Attachment> atts) {
        Object parts;
        if (atts.size() < 2) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        Attachment sigPart = atts.remove(atts.size() - 1);
        String jwsSequence = null;
        try {
            jwsSequence = IOUtils.readStringFromStream((InputStream)sigPart.getDataHandler().getInputStream());
        }
        catch (IOException ex) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        Object base64UrlEncodedHeaders = null;
        Object base64UrlEncodedSignature = null;
        if (!this.useJwsJsonSignatureFormat) {
            parts = JoseUtils.getCompactParts((String)jwsSequence);
            if (((String[])parts).length != 3 || ((String)parts[1]).length() > 0) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
            base64UrlEncodedHeaders = parts[0];
            base64UrlEncodedSignature = parts[2];
        } else {
            parts = this.reader.fromJson(jwsSequence);
            if (parts.size() != 2 || !parts.containsKey("protected") || !parts.containsKey("signature")) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
            base64UrlEncodedHeaders = (String)parts.get("protected");
            base64UrlEncodedSignature = (String)parts.get("signature");
        }
        JwsHeaders headers = new JwsHeaders(new JsonMapObjectReaderWriter().fromJson(JoseUtils.decodeToString((String)base64UrlEncodedHeaders)));
        JoseUtils.traceHeaders((JoseHeaders)headers);
        if (Boolean.FALSE != headers.getPayloadEncodingStatus()) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        JwsSignatureVerifier theVerifier = null;
        if (this.verifier == null) {
            Properties props = KeyManagementUtils.loadStoreProperties((Message)this.message, (boolean)true, (String)"rs.security.signature.in.properties", (String)"rs.security.signature.properties");
            theVerifier = JwsUtils.loadSignatureVerifier((Message)this.message, (Properties)props, (JwsHeaders)headers, (boolean)false);
        } else {
            theVerifier = this.verifier;
        }
        JwsVerificationSignature sig = theVerifier.createJwsVerificationSignature(headers);
        if (sig == null) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        byte[] signatureBytes = JoseUtils.decode((String)base64UrlEncodedSignature);
        byte[] headerBytesWithDot = StringUtils.toBytesASCII((String)((String)base64UrlEncodedHeaders + "."));
        sig.update(headerBytesWithDot, 0, headerBytesWithDot.length);
        int attSize = atts.size();
        for (int i = 0; i < attSize; ++i) {
            Attachment dataPart = atts.remove(i);
            InputStream dataPartStream = null;
            try {
                dataPartStream = dataPart.getDataHandler().getDataSource().getInputStream();
            }
            catch (IOException ex) {
                throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
            }
            boolean verifyOnLastRead = i == attSize - 1;
            JwsInputStream jwsStream = new JwsInputStream(dataPartStream, sig, signatureBytes, verifyOnLastRead);
            Object newStream = null;
            if (this.bufferPayload) {
                CachedOutputStream cos = new CachedOutputStream();
                try {
                    IOUtils.copy((InputStream)jwsStream, (OutputStream)cos);
                    newStream = cos.getInputStream();
                }
                catch (Exception ex) {
                    throw ExceptionUtils.toBadRequestException((Throwable)ex, null);
                }
            } else {
                newStream = jwsStream;
            }
            Attachment newDataPart = new Attachment((InputStream)newStream, dataPart.getHeaders());
            atts.add(i, newDataPart);
        }
    }
}

