/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.util.Set;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.JoseJaxrsUtils;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class AbstractJwsReaderProvider {
    private Set<String> protectedHttpHeaders;
    private boolean validateHttpHeaders;
    private JwsSignatureVerifier sigVerifier;
    private String defaultMediaType;

    public void setSignatureVerifier(JwsSignatureVerifier signatureVerifier) {
        this.sigVerifier = signatureVerifier;
    }

    protected JwsSignatureVerifier getInitializedSigVerifier(JwsHeaders headers) {
        JoseUtils.traceHeaders((JoseHeaders)headers);
        if (this.sigVerifier != null) {
            return this.sigVerifier;
        }
        return JwsUtils.loadSignatureVerifier((JwsHeaders)headers, (boolean)true);
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    public void setValidateHttpHeaders(boolean validateHttpHeaders) {
        this.validateHttpHeaders = validateHttpHeaders;
    }

    public boolean isValidateHttpHeaders() {
        return this.validateHttpHeaders;
    }

    protected void validateHttpHeadersIfNeeded(MultivaluedMap<String, String> httpHeaders, JwsHeaders jwsHeaders) {
        JoseJaxrsUtils.validateHttpHeaders(httpHeaders, (JoseHeaders)jwsHeaders, this.protectedHttpHeaders);
    }

    public void setProtectedHttpHeaders(Set<String> protectedHttpHeaders) {
        this.protectedHttpHeaders = protectedHttpHeaders;
    }
}

