/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PrivateKey;
import java.util.Properties;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.jose.common.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsCompactProducer {
    private JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter();
    private JwsHeaders headers;
    private String plainJwsPayload;
    private String signature;
    private boolean detached;
    private Properties signatureProperties;

    public JwsCompactProducer(String plainJwsPayload) {
        this(plainJwsPayload, false);
    }

    public JwsCompactProducer(String plainJwsPayload, boolean detached) {
        this(null, null, plainJwsPayload, detached);
    }

    public JwsCompactProducer(JwsHeaders headers, String plainJwsPayload) {
        this(headers, plainJwsPayload, false);
    }

    public JwsCompactProducer(JwsHeaders headers, String plainJwsPayload, boolean detached) {
        this(headers, null, plainJwsPayload, detached);
    }

    protected JwsCompactProducer(JwsHeaders headers, JsonMapObjectReaderWriter w, String plainJwsPayload) {
        this(headers, w, plainJwsPayload, false);
    }

    protected JwsCompactProducer(JwsHeaders headers, JsonMapObjectReaderWriter w, String plainJwsPayload, boolean detached) {
        this.headers = headers;
        if (w != null) {
            this.writer = w;
        }
        this.plainJwsPayload = plainJwsPayload;
        this.detached = detached;
    }

    public JwsHeaders getJwsHeaders() {
        if (this.headers == null) {
            this.headers = new JwsHeaders();
        }
        return this.headers;
    }

    public String getUnsignedEncodedJws() {
        this.checkAlgorithm();
        return Base64UrlUtility.encode((String)this.writer.toJson((JsonMapObject)this.getJwsHeaders())) + "." + (this.detached ? "" : Base64UrlUtility.encode((String)this.plainJwsPayload));
    }

    private String getSigningInput() {
        this.checkAlgorithm();
        boolean unencoded = JwsUtils.isPayloadUnencoded(this.getJwsHeaders());
        if (unencoded && !this.detached) {
            throw new JwsException(JwsException.Error.INVALID_COMPACT_JWS);
        }
        return Base64UrlUtility.encode((String)this.writer.toJson((JsonMapObject)this.getJwsHeaders())) + "." + (unencoded ? this.plainJwsPayload : Base64UrlUtility.encode((String)this.plainJwsPayload));
    }

    public String getEncodedSignature() {
        return this.signature;
    }

    public String getSignedEncodedJws() {
        this.checkAlgorithm();
        boolean noSignature = StringUtils.isEmpty((String)this.signature);
        if (noSignature && !this.isPlainText()) {
            throw new IllegalStateException("Signature is not available");
        }
        return this.getUnsignedEncodedJws() + "." + (noSignature ? "" : this.signature);
    }

    public String signWith(JsonWebKey jwk) {
        return this.signWith(JwsUtils.getSignatureProvider(jwk, this.headers.getSignatureAlgorithm()));
    }

    public String signWith(PrivateKey key) {
        return this.signWith(JwsUtils.getPrivateKeySignatureProvider(key, this.headers.getSignatureAlgorithm()));
    }

    public String signWith(byte[] key) {
        return this.signWith(JwsUtils.getHmacSignatureProvider(key, this.headers.getSignatureAlgorithm()));
    }

    public String signWith(JwsSignatureProvider signer) {
        if (this.headers.getSignatureAlgorithm() == null) {
            this.headers.setSignatureAlgorithm(signer.getAlgorithm());
        }
        byte[] bytes = StringUtils.toBytesUTF8((String)this.getSigningInput());
        byte[] sig = signer.sign(this.getJwsHeaders(), bytes);
        return this.setSignatureBytes(sig);
    }

    public String setSignatureText(String signatureText) {
        this.setEncodedSignature(Base64UrlUtility.encode((String)signatureText));
        return this.getSignedEncodedJws();
    }

    public boolean isPlainText() {
        return SignatureAlgorithm.NONE == this.getAlgorithm();
    }

    public String setSignatureBytes(byte[] signatureOctets) {
        this.setEncodedSignature(Base64UrlUtility.encode((byte[])signatureOctets));
        return this.getSignedEncodedJws();
    }

    private void setEncodedSignature(String sig) {
        this.signature = sig;
    }

    private SignatureAlgorithm getAlgorithm() {
        return this.getJwsHeaders().getSignatureAlgorithm();
    }

    private void checkAlgorithm() {
        if (this.getAlgorithm() == null) {
            Properties sigProps = this.getSignatureProperties();
            Message m = PhaseInterceptorChain.getCurrentMessage();
            String signatureAlgo = JwsUtils.getSignatureAlgo(m, sigProps, null, null);
            if (signatureAlgo != null) {
                this.getJwsHeaders().setSignatureAlgorithm(SignatureAlgorithm.getAlgorithm(signatureAlgo));
            }
        }
        if (this.getAlgorithm() == null) {
            throw new JwsException(JwsException.Error.INVALID_ALGORITHM);
        }
    }

    public Properties getSignatureProperties() {
        if (this.signatureProperties == null && PhaseInterceptorChain.getCurrentMessage() != null) {
            Message m = PhaseInterceptorChain.getCurrentMessage();
            this.signatureProperties = KeyManagementUtils.loadStoreProperties(m, false, "rs.security.signature.out.properties", "rs.security.signature.properties");
        }
        return this.signatureProperties;
    }

    public void setSignatureProperties(Properties signatureProperties) {
        this.signatureProperties = signatureProperties;
    }
}

