/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseType;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;

public class JwsHeaders
extends JoseHeaders {
    public JwsHeaders() {
    }

    public JwsHeaders(JoseType type) {
        super(type);
    }

    public JwsHeaders(JoseHeaders headers) {
        super(headers.asMap());
    }

    public JwsHeaders(Map<String, Object> values) {
        super(values);
    }

    public JwsHeaders(SignatureAlgorithm sigAlgo) {
        this.init(sigAlgo);
    }

    public JwsHeaders(JoseType type, SignatureAlgorithm sigAlgo) {
        super(type);
        this.init(sigAlgo);
    }

    private void init(SignatureAlgorithm sigAlgo) {
        this.setSignatureAlgorithm(sigAlgo);
    }

    public void setSignatureAlgorithm(SignatureAlgorithm algo) {
        super.setAlgorithm(algo.getJwaName());
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        String algo = super.getAlgorithm();
        return algo == null ? null : SignatureAlgorithm.getAlgorithm(algo);
    }

    public void setPayloadEncodingStatus(Boolean status) {
        super.setProperty("b64", (Object)status);
        if (!status.booleanValue()) {
            List<String> critical = this.getCritical();
            if (critical == null) {
                critical = new LinkedList<String>();
                this.setCritical(critical);
            } else if (critical.contains("b64")) {
                return;
            }
            critical.add("b64");
        }
    }

    public Boolean getPayloadEncodingStatus() {
        return super.getBooleanProperty("b64");
    }
}

