/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.rs.security.jose.AbstractJoseObject;

public class AbstractJoseObjectReaderWriter {
    private static final Set<String> DATE_PROPERTIES = new HashSet<String>(Arrays.asList("exp", "iat", "nbf"));
    private boolean format;

    protected String toJson(AbstractJoseObject jwt) {
        StringBuilder sb = new StringBuilder();
        this.toJsonInternal(sb, jwt.asMap());
        return sb.toString();
    }

    protected void toJsonInternal(StringBuilder sb, Map<String, Object> map) {
        sb.append("{");
        Iterator<Map.Entry<String, Object>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> entry = it.next();
            sb.append("\"").append(entry.getKey()).append("\"");
            sb.append(":");
            this.toJsonInternal(sb, entry.getValue(), it.hasNext());
        }
        sb.append("}");
    }

    protected void toJsonInternal(StringBuilder sb, Object[] array) {
        this.toJsonInternal(sb, Arrays.asList(array));
    }

    protected void toJsonInternal(StringBuilder sb, Collection<?> coll) {
        sb.append("[");
        this.formatIfNeeded(sb);
        Iterator<?> iter = coll.iterator();
        while (iter.hasNext()) {
            this.toJsonInternal(sb, iter.next(), iter.hasNext());
        }
        this.formatIfNeeded(sb);
        sb.append("]");
    }

    protected void toJsonInternal(StringBuilder sb, Object value, boolean hasNext) {
        if (AbstractJoseObject.class.isAssignableFrom(value.getClass())) {
            sb.append(this.toJson((AbstractJoseObject)value));
        } else if (value.getClass().isArray()) {
            this.toJsonInternal(sb, (Object[])value);
        } else if (Collection.class.isAssignableFrom(value.getClass())) {
            this.toJsonInternal(sb, (Collection)value);
        } else if (Map.class.isAssignableFrom(value.getClass())) {
            this.toJsonInternal(sb, (Map)value);
        } else {
            if (value.getClass() == String.class) {
                sb.append("\"");
            }
            sb.append(value);
            if (value.getClass() == String.class) {
                sb.append("\"");
            }
        }
        if (hasNext) {
            sb.append(",");
            this.formatIfNeeded(sb);
        }
    }

    protected void formatIfNeeded(StringBuilder sb) {
        if (this.format) {
            sb.append("\r\n ");
        }
    }

    protected void fromJsonInternal(AbstractJoseObject jwt, String json) {
        String theJson = json.trim();
        JoseObjectSettable joseObject = new JoseObjectSettable(jwt);
        this.readJwtObjectAsMap(joseObject, theJson.substring(1, theJson.length() - 1));
    }

    protected void readJwtObjectAsMap(Settable values, String json) {
        for (int i = 0; i < json.length(); ++i) {
            String newJson;
            int closingIndex;
            if (this.isWhiteSpace(json.charAt(i))) continue;
            int closingQuote = json.indexOf(34, i + 1);
            int from = json.charAt(i) == '\"' ? i + 1 : i;
            String name = json.substring(from, closingQuote);
            int sepIndex = json.indexOf(58, closingQuote + 1);
            int j = 1;
            while (this.isWhiteSpace(json.charAt(sepIndex + j))) {
                ++j;
            }
            if (json.charAt(sepIndex + j) == '{') {
                closingIndex = this.getClosingIndex(json, '{', '}', sepIndex + j);
                newJson = json.substring(sepIndex + j + 1, closingIndex);
                MapSettable nextMap = new MapSettable();
                this.readJwtObjectAsMap(nextMap, newJson);
                values.put(name, nextMap.map);
                i = closingIndex + 1;
                continue;
            }
            if (json.charAt(sepIndex + j) == '[') {
                closingIndex = this.getClosingIndex(json, '[', ']', sepIndex + j);
                newJson = json.substring(sepIndex + j + 1, closingIndex);
                values.put(name, this.readJwtObjectAsList(newJson));
                i = closingIndex + 1;
                continue;
            }
            int commaIndex = AbstractJoseObjectReaderWriter.getCommaIndex(json, sepIndex + j);
            Object value = this.readPrimitiveValue(json, sepIndex + j, commaIndex);
            if (DATE_PROPERTIES.contains(name)) {
                value = Long.valueOf(value.toString());
            }
            values.put(name, value);
            i = commaIndex + 1;
        }
    }

    protected List<Object> readJwtObjectAsList(String json) {
        LinkedList<Object> values = new LinkedList<Object>();
        for (int i = 0; i < json.length(); ++i) {
            if (this.isWhiteSpace(json.charAt(i))) continue;
            if (json.charAt(i) == '{') {
                int closingIndex = this.getClosingIndex(json, '{', '}', i);
                MapSettable nextMap = new MapSettable();
                this.readJwtObjectAsMap(nextMap, json.substring(i + 1, closingIndex));
                values.add(nextMap.map);
                i = closingIndex + 1;
                continue;
            }
            int commaIndex = AbstractJoseObjectReaderWriter.getCommaIndex(json, i);
            Object value = this.readPrimitiveValue(json, i, commaIndex);
            values.add(value);
            i = commaIndex + 1;
        }
        return values;
    }

    protected Object readPrimitiveValue(String json, int from, int to) {
        Object value = json.substring(from, to);
        String valueStr = value.toString().trim();
        if (valueStr.startsWith("\"")) {
            value = valueStr.substring(1, valueStr.length() - 1);
        } else if ("true".equals(value) || "false".equals(value)) {
            value = Boolean.valueOf(valueStr);
        }
        return value;
    }

    protected static int getCommaIndex(String json, int from) {
        int commaIndex = json.indexOf(",", from);
        if (commaIndex == -1) {
            commaIndex = json.length();
        }
        return commaIndex;
    }

    protected int getClosingIndex(String json, char openChar, char closeChar, int from) {
        int nextOpenIndex = json.indexOf(openChar, from + 1);
        int closingIndex = json.indexOf(closeChar, from + 1);
        while (nextOpenIndex != -1 && nextOpenIndex < closingIndex) {
            nextOpenIndex = json.indexOf(openChar, closingIndex + 1);
            closingIndex = json.indexOf(closeChar, closingIndex + 1);
        }
        return closingIndex;
    }

    protected boolean isWhiteSpace(char jsonChar) {
        return jsonChar == ' ' || jsonChar == '\r' || jsonChar == '\n' || jsonChar == '\t';
    }

    public void setFormat(boolean format) {
        this.format = format;
    }

    private static class JoseObjectSettable
    implements Settable {
        private AbstractJoseObject jose;

        public JoseObjectSettable(AbstractJoseObject jose) {
            this.jose = jose;
        }

        @Override
        public void put(String key, Object value) {
            this.jose.setValue(key, value);
        }
    }

    private static class MapSettable
    implements Settable {
        private Map<String, Object> map = new LinkedHashMap<String, Object>();

        private MapSettable() {
        }

        @Override
        public void put(String key, Object value) {
            this.map.put(key, value);
        }
    }

    private static interface Settable {
        public void put(String var1, Object var2);
    }
}

