/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.jose.AbstractJoseObject;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;

public class JoseHeaders
extends AbstractJoseObject {
    private Map<String, Integer> headerUpdateCount;

    public JoseHeaders() {
    }

    public JoseHeaders(Map<String, Object> values) {
        super(values);
    }

    public void setType(String type) {
        this.setHeader("typ", type);
    }

    public String getType() {
        return (String)this.getHeader("typ");
    }

    public void setContentType(String type) {
        this.setHeader("cty", type);
    }

    public String getContentType() {
        return (String)this.getHeader("cty");
    }

    public void setAlgorithm(String algo) {
        this.setHeader("alg", algo);
    }

    public String getAlgorithm() {
        return (String)this.getHeader("alg");
    }

    public void setKeyId(String kid) {
        this.setHeader("kid", kid);
    }

    public String getKeyId() {
        return (String)this.getHeader("kid");
    }

    public void setX509Url(String x509Url) {
        this.setHeader("x5u", x509Url);
    }

    public String getX509Url() {
        return (String)this.getHeader("x5u");
    }

    public void setX509Chain(String x509Chain) {
        this.setHeader("x5c", x509Chain);
    }

    public String getX509Chain() {
        return (String)this.getHeader("x5c");
    }

    public void setX509Thumbprint(String x509Thumbprint) {
        this.setHeader("x5t", x509Thumbprint);
    }

    public String getX509Thumbprint() {
        return (String)this.getHeader("x5t");
    }

    public void setX509ThumbprintSHA256(String x509Thumbprint) {
        this.setHeader("x5t#S256", x509Thumbprint);
    }

    public String getX509ThumbprintSHA256() {
        return (String)super.getValue("x5t#S256");
    }

    public void setCritical(List<String> crit) {
        this.setHeader("crit", crit);
    }

    public List<String> getCritical() {
        return CastUtils.cast((List)((List)this.getHeader("crit")));
    }

    public void setJsonWebKey(JsonWebKey key) {
        this.setHeader("jwk", key);
    }

    public JsonWebKey getJsonWebKey() {
        Object jsonWebKey = this.getValue("jwk");
        if (jsonWebKey == null || jsonWebKey instanceof JsonWebKey) {
            return (JsonWebKey)jsonWebKey;
        }
        Map map = CastUtils.cast((Map)((Map)jsonWebKey));
        return new JsonWebKey(map);
    }

    public JoseHeaders setHeader(String name, Object value) {
        this.setValue(name, value);
        return this;
    }

    @Override
    protected void setValue(String name, Object value) {
        if (this.values.containsKey(name)) {
            int n;
            Integer count;
            if (this.headerUpdateCount == null) {
                this.headerUpdateCount = new LinkedHashMap<String, Integer>();
            }
            if ((count = this.headerUpdateCount.get(name)) == null) {
                n = 2;
            } else {
                Integer n2 = count;
                Integer n3 = count = Integer.valueOf(count + 1);
                n = n2;
            }
            count = n;
            this.headerUpdateCount.put(name, count);
        }
        super.setValue(name, value);
    }

    public Object getHeader(String name) {
        return this.getValue(name);
    }

    public JoseHeaders setIntegerHeader(String name, Integer value) {
        this.setHeader(name, value);
        return this;
    }

    public Integer getIntegerHeader(String name) {
        Object value = this.getHeader(name);
        if (value != null) {
            return value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
        }
        return null;
    }

    public JoseHeaders setLongHeader(String name, Long value) {
        this.setHeader(name, value);
        return this;
    }

    public Long getLongHeader(String name) {
        Object value = this.getHeader(name);
        if (value != null) {
            return value instanceof Long ? (Long)value : Long.parseLong(value.toString());
        }
        return null;
    }

    public Map<String, Object> getHeaderUpdateCount() {
        return this.headerUpdateCount == null ? null : Collections.unmodifiableMap(this.headerUpdateCount);
    }
}

