/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.security.interfaces.RSAPrivateKey;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAOaepKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyJweDecryption;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;

public class AbstractJweDecryptingFilter {
    private static final String RSSEC_ENCRYPTION_IN_PROPS = "rs.security.encryption.in.properties";
    private static final String RSSEC_ENCRYPTION_PROPS = "rs.security.encryption.properties";
    private static final String JSON_WEB_ENCRYPTION_KEY_ALGO_PROP = "rs.security.jwe.key.encryption.algorithm";
    private static final String JSON_WEB_ENCRYPTION_CEK_ALGO_PROP = "rs.security.jwe.content.encryption.algorithm";
    private JweDecryptionProvider decryption;
    private String defaultMediaType;

    protected JweDecryptionOutput decrypt(InputStream is) throws IOException {
        JweDecryptionProvider theDecryptor = this.getInitializedDecryptionProvider();
        JweDecryptionOutput out = theDecryptor.decrypt(new String(IOUtils.readBytesFromStream((InputStream)is), "UTF-8"));
        this.validateHeaders(out.getHeaders());
        return out;
    }

    protected void validateHeaders(JweHeaders headers) {
    }

    public void setDecryptionProvider(JweDecryptionProvider decryptor) {
        this.decryption = decryptor;
    }

    protected JweDecryptionProvider getInitializedDecryptionProvider() {
        if (this.decryption != null) {
            return this.decryption;
        }
        Message m = JAXRSUtils.getCurrentMessage();
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)RSSEC_ENCRYPTION_IN_PROPS, (String)RSSEC_ENCRYPTION_PROPS);
        if (propLoc == null) {
            throw new SecurityException();
        }
        Bus bus = m.getExchange().getBus();
        try {
            KeyDecryptionAlgorithm keyDecryptionProvider = null;
            Properties props = ResourceUtils.loadProperties((String)propLoc, (Bus)bus);
            String contentEncryptionAlgo = props.getProperty(JSON_WEB_ENCRYPTION_CEK_ALGO_PROP);
            SecretKey ctDecryptionKey = null;
            if ("jwk".equals(props.get("rs.security.keystore.type"))) {
                JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "encrypt");
                String keyEncryptionAlgo = this.getKeyEncryptionAlgo(props, jwk.getAlgorithm());
                if ("direct".equals(keyEncryptionAlgo)) {
                    contentEncryptionAlgo = this.getContentEncryptionAlgo(props, contentEncryptionAlgo);
                    ctDecryptionKey = JweUtils.getContentDecryptionSecretKey(jwk, contentEncryptionAlgo);
                } else {
                    keyDecryptionProvider = JweUtils.getKeyDecryptionAlgorithm(jwk, keyEncryptionAlgo);
                }
            } else {
                keyDecryptionProvider = new RSAOaepKeyDecryptionAlgorithm((RSAPrivateKey)KeyManagementUtils.loadPrivateKey(m, props, "rs.security.decryption.key.password.provider"));
            }
            if (keyDecryptionProvider == null && ctDecryptionKey == null) {
                throw new SecurityException();
            }
            if (keyDecryptionProvider != null) {
                if (Algorithm.isAesCbcHmac(contentEncryptionAlgo)) {
                    return new AesCbcHmacJweDecryption(keyDecryptionProvider, contentEncryptionAlgo);
                }
                return new WrappedKeyJweDecryption(keyDecryptionProvider, new AesGcmContentDecryptionAlgorithm(contentEncryptionAlgo));
            }
            return new DirectKeyJweDecryption(ctDecryptionKey, new AesGcmContentDecryptionAlgorithm(contentEncryptionAlgo));
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private String getKeyEncryptionAlgo(Properties props, String algo) {
        return algo == null ? props.getProperty(JSON_WEB_ENCRYPTION_KEY_ALGO_PROP) : algo;
    }

    private String getContentEncryptionAlgo(Properties props, String algo) {
        return algo == null ? props.getProperty(JSON_WEB_ENCRYPTION_CEK_ALGO_PROP) : algo;
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }
}

