/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.security.interfaces.RSAPublicKey;
import java.util.Properties;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;

public class AbstractJwsReaderProvider {
    private static final String RSSEC_SIGNATURE_IN_PROPS = "rs.security.signature.in.properties";
    private static final String RSSEC_SIGNATURE_PROPS = "rs.security.signature.properties";
    private static final String JSON_WEB_SIGNATURE_ALGO_PROP = "rs.security.jws.content.signature.algorithm";
    private JwsSignatureVerifier sigVerifier;
    private String defaultMediaType;

    public void setSignatureVerifier(JwsSignatureVerifier signatureVerifier) {
        this.sigVerifier = signatureVerifier;
    }

    protected JwsSignatureVerifier getInitializedSigVerifier() {
        if (this.sigVerifier != null) {
            return this.sigVerifier;
        }
        Message m = JAXRSUtils.getCurrentMessage();
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)RSSEC_SIGNATURE_IN_PROPS, (String)RSSEC_SIGNATURE_PROPS);
        if (propLoc == null) {
            throw new SecurityException();
        }
        Bus bus = m.getExchange().getBus();
        try {
            Properties props = ResourceUtils.loadProperties((String)propLoc, (Bus)bus);
            JwsSignatureVerifier theVerifier = null;
            String rsaSignatureAlgo = null;
            if ("jwk".equals(props.get("rs.security.keystore.type"))) {
                JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "verify");
                rsaSignatureAlgo = this.getSignatureAlgo(props, jwk.getAlgorithm());
                theVerifier = JwsUtils.getSignatureVerifier(jwk, rsaSignatureAlgo);
            } else {
                theVerifier = new PublicKeyJwsSignatureVerifier((RSAPublicKey)KeyManagementUtils.loadPublicKey(m, props));
            }
            return theVerifier;
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public String getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public void setDefaultMediaType(String defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
    }

    private String getSignatureAlgo(Properties props, String algo) {
        return algo == null ? props.getProperty(JSON_WEB_SIGNATURE_ALGO_PROP) : algo;
    }
}

