/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.interfaces.RSAPrivateKey;
import java.util.Properties;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtHeaders;

public class AbstractJwsWriterProvider {
    private static final String RSSEC_SIGNATURE_OUT_PROPS = "rs.security.signature.out.properties";
    private static final String RSSEC_SIGNATURE_PROPS = "rs.security.signature.properties";
    private static final String JSON_WEB_SIGNATURE_ALGO_PROP = "rs.security.jws.content.signature.algorithm";
    private JwsSignatureProvider sigProvider;

    public void setSignatureProvider(JwsSignatureProvider signatureProvider) {
        this.sigProvider = signatureProvider;
    }

    protected JwsSignatureProvider getInitializedSigProvider(JwtHeaders headers) {
        if (this.sigProvider != null) {
            return this.sigProvider;
        }
        Message m = JAXRSUtils.getCurrentMessage();
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)RSSEC_SIGNATURE_OUT_PROPS, (String)RSSEC_SIGNATURE_PROPS);
        if (propLoc == null) {
            throw new SecurityException();
        }
        try {
            Properties props = ResourceUtils.loadProperties((String)propLoc, (Bus)m.getExchange().getBus());
            JwsSignatureProvider theSigProvider = null;
            String rsaSignatureAlgo = null;
            if ("jwk".equals(props.get("rs.security.keystore.type"))) {
                JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "sign");
                rsaSignatureAlgo = this.getSignatureAlgo(props, jwk.getAlgorithm());
                theSigProvider = JwsUtils.getSignatureProvider(jwk, rsaSignatureAlgo);
            } else {
                rsaSignatureAlgo = this.getSignatureAlgo(props, null);
                RSAPrivateKey pk = (RSAPrivateKey)KeyManagementUtils.loadPrivateKey(m, props, "rs.security.signature.key.password.provider");
                theSigProvider = new PrivateKeyJwsSignatureProvider(pk, rsaSignatureAlgo);
            }
            if (theSigProvider == null) {
                throw new SecurityException();
            }
            headers.setAlgorithm(rsaSignatureAlgo);
            return theSigProvider;
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    protected void writeJws(JwsCompactProducer p, JwsSignatureProvider theSigProvider, OutputStream os) throws IOException {
        p.signWith(theSigProvider);
        IOUtils.copy((InputStream)new ByteArrayInputStream(p.getSignedEncodedJws().getBytes("UTF-8")), (OutputStream)os);
    }

    private String getSignatureAlgo(Properties props, String algo) {
        return algo == null ? props.getProperty(JSON_WEB_SIGNATURE_ALGO_PROP) : algo;
    }
}

