/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.interfaces.RSAPublicKey;
import java.util.Properties;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.Bus;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.JoseHeadersWriter;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.DirectKeyJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweCompactProducer;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionState;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweOutputStream;
import org.apache.cxf.rs.security.jose.jwe.JweUtils;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAOaepKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyJweEncryption;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;

@Priority(value=1000)
public class JweWriterInterceptor
implements WriterInterceptor {
    private static final String RSSEC_ENCRYPTION_OUT_PROPS = "rs.security.encryption.out.properties";
    private static final String RSSEC_ENCRYPTION_PROPS = "rs.security.encryption.properties";
    private static final String JSON_WEB_ENCRYPTION_CEK_ALGO_PROP = "rs.security.jwe.content.encryption.algorithm";
    private static final String JSON_WEB_ENCRYPTION_KEY_ALGO_PROP = "rs.security.jwe.key.encryption.algorithm";
    private static final String JSON_WEB_ENCRYPTION_ZIP_ALGO_PROP = "rs.security.jwe.zip.algorithm";
    private JweEncryptionProvider encryptionProvider;
    private boolean contentTypeRequired = true;
    private boolean useJweOutputStream;
    private JoseHeadersWriter writer = new JoseHeadersReaderWriter();

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        MediaType mt;
        OutputStream actualOs = ctx.getOutputStream();
        JweEncryptionProvider theEncryptionProvider = this.getInitializedEncryptionProvider();
        String ctString = null;
        if (this.contentTypeRequired && (mt = ctx.getMediaType()) != null) {
            ctString = "application".equals(mt.getType()) ? mt.getSubtype() : JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0]);
        }
        ctx.setMediaType(JAXRSUtils.toMediaType((String)"application/jose+json"));
        if (this.useJweOutputStream) {
            JweEncryptionState encryption = theEncryptionProvider.createJweEncryptionState(ctString);
            try {
                JweCompactProducer.startJweContent(actualOs, encryption.getHeaders(), this.writer, encryption.getContentEncryptionKey(), encryption.getIv());
            }
            catch (IOException ex) {
                throw new SecurityException(ex);
            }
            FilterOutputStream jweStream = new JweOutputStream(actualOs, encryption.getCipher(), encryption.getAuthTagProducer());
            if (encryption.isCompressionSupported()) {
                jweStream = new DeflaterOutputStream(jweStream);
            }
            ctx.setOutputStream((OutputStream)jweStream);
            ctx.proceed();
            ((OutputStream)jweStream).flush();
        } else {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            String jweContent = theEncryptionProvider.encrypt(cos.getBytes(), ctString);
            IOUtils.copy((InputStream)new ByteArrayInputStream(jweContent.getBytes("UTF-8")), (OutputStream)actualOs);
            actualOs.flush();
        }
    }

    protected JweEncryptionProvider getInitializedEncryptionProvider() {
        if (this.encryptionProvider != null) {
            return this.encryptionProvider;
        }
        Message m = JAXRSUtils.getCurrentMessage();
        String propLoc = (String)MessageUtils.getContextualProperty((Message)m, (String)RSSEC_ENCRYPTION_OUT_PROPS, (String)RSSEC_ENCRYPTION_PROPS);
        if (propLoc == null) {
            throw new SecurityException();
        }
        Bus bus = m.getExchange().getBus();
        try {
            KeyEncryptionAlgorithm keyEncryptionProvider = null;
            String keyEncryptionAlgo = null;
            Properties props = ResourceUtils.loadProperties((String)propLoc, (Bus)bus);
            String contentEncryptionAlgo = props.getProperty(JSON_WEB_ENCRYPTION_CEK_ALGO_PROP);
            ContentEncryptionAlgorithm ctEncryptionProvider = null;
            if ("jwk".equals(props.get("rs.security.keystore.type"))) {
                JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "encrypt");
                keyEncryptionAlgo = this.getKeyEncryptionAlgo(props, jwk.getAlgorithm());
                if ("direct".equals(keyEncryptionAlgo)) {
                    contentEncryptionAlgo = this.getContentEncryptionAlgo(props, jwk.getAlgorithm());
                    ctEncryptionProvider = JweUtils.getContentEncryptionAlgorithm(jwk, contentEncryptionAlgo);
                } else {
                    keyEncryptionProvider = JweUtils.getKeyEncryptionAlgorithm(jwk, keyEncryptionAlgo);
                }
            } else {
                keyEncryptionProvider = new RSAOaepKeyEncryptionAlgorithm((RSAPublicKey)KeyManagementUtils.loadPublicKey(m, props), this.getKeyEncryptionAlgo(props, keyEncryptionAlgo));
            }
            if (keyEncryptionProvider == null && ctEncryptionProvider == null) {
                throw new SecurityException();
            }
            JweHeaders headers = new JweHeaders(this.getKeyEncryptionAlgo(props, keyEncryptionAlgo), contentEncryptionAlgo);
            String compression = props.getProperty(JSON_WEB_ENCRYPTION_ZIP_ALGO_PROP);
            if (compression != null) {
                headers.setZipAlgorithm(compression);
            }
            if (keyEncryptionProvider != null) {
                if (Algorithm.isAesCbcHmac(contentEncryptionAlgo)) {
                    return new AesCbcHmacJweEncryption(contentEncryptionAlgo, keyEncryptionProvider);
                }
                return new WrappedKeyJweEncryption(headers, keyEncryptionProvider, new AesGcmContentEncryptionAlgorithm(contentEncryptionAlgo));
            }
            return new DirectKeyJweEncryption(ctEncryptionProvider);
        }
        catch (SecurityException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private String getKeyEncryptionAlgo(Properties props, String algo) {
        return algo == null ? props.getProperty(JSON_WEB_ENCRYPTION_KEY_ALGO_PROP) : algo;
    }

    private String getContentEncryptionAlgo(Properties props, String algo) {
        return algo == null ? props.getProperty(JSON_WEB_ENCRYPTION_CEK_ALGO_PROP) : algo;
    }

    public void setUseJweOutputStream(boolean useJweOutputStream) {
        this.useJweOutputStream = useJweOutputStream;
    }

    public void setWriter(JoseHeadersWriter writer) {
        this.writer = writer;
    }

    public void setEncryptionProvider(JweEncryptionProvider encryptionProvider) {
        this.encryptionProvider = encryptionProvider;
    }
}

