/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsReaderProvider;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;

@PreMatching
@Priority(value=1001)
public class JwsContainerRequestFilter
extends AbstractJwsReaderProvider
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext context) throws IOException {
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier();
        JwsCompactConsumer p = new JwsCompactConsumer(IOUtils.readStringFromStream((InputStream)context.getEntityStream()));
        if (!p.verifySignatureWith(theSigVerifier)) {
            context.abortWith(JAXRSUtils.toResponse((int)400));
            return;
        }
        byte[] bytes = p.getDecodedJwsPayloadBytes();
        context.setEntityStream((InputStream)new ByteArrayInputStream(bytes));
        context.getHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString(bytes.length));
        String ct = JoseUtils.checkContentType(p.getJwsHeaders().getContentType(), this.getDefaultMediaType());
        if (ct != null) {
            context.getHeaders().putSingle((Object)"Content-Type", (Object)ct);
        }
    }
}

