/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Priority;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.apache.cxf.common.util.Base64UrlOutputStream;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.JoseHeadersWriter;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsWriterProvider;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsOutputStream;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jwt.JwtHeaders;

@Priority(value=1001)
public class JwsWriterInterceptor
extends AbstractJwsWriterProvider
implements WriterInterceptor {
    private boolean contentTypeRequired = true;
    private boolean useJwsOutputStream;
    private JoseHeadersWriter writer = new JoseHeadersReaderWriter();

    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        JwsHeaders headers = new JwsHeaders();
        JwsSignatureProvider sigProvider = this.getInitializedSigProvider(headers);
        this.setContentTypeIfNeeded(headers, ctx);
        ctx.setMediaType(JAXRSUtils.toMediaType((String)"application/jose+json"));
        OutputStream actualOs = ctx.getOutputStream();
        if (this.useJwsOutputStream) {
            JwsSignature jwsSignature = sigProvider.createJwsSignature(headers);
            JwsOutputStream jwsStream = new JwsOutputStream(actualOs, jwsSignature);
            byte[] headerBytes = this.writer.headersToJson(headers).getBytes("UTF-8");
            Base64UrlUtility.encodeAndStream((byte[])headerBytes, (int)0, (int)headerBytes.length, (OutputStream)jwsStream);
            jwsStream.write(new byte[]{46});
            Base64UrlOutputStream base64Stream = new Base64UrlOutputStream((OutputStream)jwsStream);
            ctx.setOutputStream((OutputStream)base64Stream);
            ctx.proceed();
            base64Stream.flush();
            jwsStream.flush();
        } else {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream((OutputStream)cos);
            ctx.proceed();
            JwsCompactProducer p = new JwsCompactProducer(headers, new String(cos.getBytes(), "UTF-8"));
            this.writeJws(p, sigProvider, actualOs);
        }
    }

    public void setContentTypeRequired(boolean contentTypeRequired) {
        this.contentTypeRequired = contentTypeRequired;
    }

    public void setUseJwsOutputStream(boolean useJwsOutputStream) {
        this.useJwsOutputStream = useJwsOutputStream;
    }

    public void setWriter(JoseHeadersWriter writer) {
        this.writer = writer;
    }

    private void setContentTypeIfNeeded(JwtHeaders headers, WriterInterceptorContext ctx) {
        MediaType mt;
        if (this.contentTypeRequired && (mt = ctx.getMediaType()) != null && !JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0]).equals("application/jose+json")) {
            if ("application".equals(mt.getType())) {
                headers.setContentType(mt.getSubtype());
            } else {
                headers.setContentType(JAXRSUtils.mediaTypeToString((MediaType)mt, (String[])new String[0]));
            }
        }
    }
}

