/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public abstract class AbstractContentEncryptionCipherProperties
implements ContentEncryptionCipherProperties {
    private static final int DEFAULT_AUTH_TAG_LENGTH = 128;
    private int authTagLen = 128;

    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
        return CryptoUtils.getContentEncryptionCipherSpec((int)this.getAuthTagLen(), (byte[])theIv);
    }

    @Override
    public byte[] getAdditionalAuthenticationData(String headersJson) {
        return JweHeaders.toCipherAdditionalAuthData(headersJson);
    }

    protected int getAuthTagLen() {
        return this.authTagLen;
    }
}

