/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class AesGcmContentDecryptionAlgorithm
extends AbstractContentEncryptionCipherProperties
implements ContentDecryptionAlgorithm {
    private String supportedAlgo;

    public AesGcmContentDecryptionAlgorithm() {
        this(null);
    }

    public AesGcmContentDecryptionAlgorithm(String supportedAlgo) {
        this.supportedAlgo = supportedAlgo;
    }

    @Override
    public byte[] getEncryptedSequence(JweHeaders headers, byte[] cipher, byte[] authTag) {
        String algo = headers.getContentEncryptionAlgorithm();
        if (!Algorithm.isAesGcm(algo) || this.supportedAlgo != null && !this.supportedAlgo.equals(algo)) {
            throw new SecurityException();
        }
        return JweCompactConsumer.getCipherWithAuthTag(cipher, authTag);
    }
}

