/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;

public class DirectKeyDecryptionAlgorithm
implements KeyDecryptionAlgorithm {
    private byte[] contentDecryptionKey;

    public DirectKeyDecryptionAlgorithm(Key contentDecryptionKey) {
        this(contentDecryptionKey.getEncoded());
    }

    public DirectKeyDecryptionAlgorithm(byte[] contentDecryptionKey) {
        this.contentDecryptionKey = contentDecryptionKey;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweCompactConsumer consumer) {
        byte[] encryptedCEK = consumer.getEncryptedContentEncryptionKey();
        if (encryptedCEK != null && encryptedCEK.length > 0) {
            throw new SecurityException();
        }
        return this.contentDecryptionKey;
    }
}

