/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.io.UnsupportedEncodingException;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseHeadersReader;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;

public class JweCompactConsumer {
    private String headersJson;
    private byte[] encryptedCEK;
    private byte[] initVector;
    private byte[] encryptedContent;
    private byte[] authTag;
    private JweHeaders jweHeaders;

    public JweCompactConsumer(String jweContent) {
        this(jweContent, new JoseHeadersReaderWriter());
    }

    public JweCompactConsumer(String jweContent, JoseHeadersReader reader) {
        String[] parts = jweContent.split("\\.");
        if (parts.length != 5) {
            throw new SecurityException("5 JWE parts are expected");
        }
        try {
            this.headersJson = new String(Base64UrlUtility.decode((String)parts[0]));
            this.encryptedCEK = Base64UrlUtility.decode((String)parts[1]);
            this.initVector = Base64UrlUtility.decode((String)parts[2]);
            this.encryptedContent = Base64UrlUtility.decode((String)parts[3]);
            this.authTag = Base64UrlUtility.decode((String)parts[4]);
            JoseHeaders joseHeaders = reader.fromJsonHeaders(this.headersJson);
            if (joseHeaders.getHeaderUpdateCount() != null) {
                throw new SecurityException();
            }
            this.jweHeaders = new JweHeaders(joseHeaders);
        }
        catch (Base64Exception ex) {
            throw new SecurityException(ex);
        }
    }

    public String getDecodedJsonHeaders() {
        return this.headersJson;
    }

    public JweHeaders getJweHeaders() {
        return this.jweHeaders;
    }

    public byte[] getEncryptedContentEncryptionKey() {
        return this.encryptedCEK;
    }

    public byte[] getContentDecryptionCipherInitVector() {
        return this.initVector;
    }

    public byte[] getContentEncryptionCipherAAD() {
        return JweHeaders.toCipherAdditionalAuthData(this.headersJson);
    }

    public byte[] getEncryptionAuthenticationTag() {
        return this.authTag;
    }

    public byte[] getEncryptedContent() {
        return this.encryptedContent;
    }

    public byte[] getEncryptedContentWithAuthTag() {
        return JweCompactConsumer.getCipherWithAuthTag(this.encryptedContent, this.authTag);
    }

    public static byte[] getCipherWithAuthTag(byte[] cipher, byte[] authTag) {
        byte[] encryptedContentWithTag = new byte[cipher.length + authTag.length];
        System.arraycopy(cipher, 0, encryptedContentWithTag, 0, cipher.length);
        System.arraycopy(authTag, 0, encryptedContentWithTag, cipher.length, authTag.length);
        return encryptedContentWithTag;
    }

    public byte[] getDecryptedContent(JweDecryptionProvider decryption) {
        return decryption.decrypt(this);
    }

    public String getDecryptedContentText(JweDecryptionProvider decryption) {
        try {
            return new String(this.getDecryptedContent(decryption), "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SecurityException(ex);
        }
    }
}

