/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.JoseHeadersReaderWriter;
import org.apache.cxf.rs.security.jose.JoseHeadersWriter;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwt.JwtTokenReaderWriter;

public class JweCompactProducer {
    private StringBuilder jweContentBuilder;
    private String encodedEncryptedContent;
    private String encodedAuthTag;

    public JweCompactProducer(JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentNoTag, byte[] authenticationTag) {
        this(headers, null, encryptedContentEncryptionKey, cipherInitVector, encryptedContentNoTag, authenticationTag);
    }

    public JweCompactProducer(JweHeaders headers, JoseHeadersWriter writer, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentNoTag, byte[] authenticationTag) {
        this(JweCompactProducer.getHeadersJson(headers, writer), encryptedContentEncryptionKey, cipherInitVector, encryptedContentNoTag, authenticationTag);
    }

    public JweCompactProducer(String headersJson, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentNoTag, byte[] authenticationTag) {
        this.jweContentBuilder = JweCompactProducer.startJweContent(new StringBuilder(), headersJson, encryptedContentEncryptionKey, cipherInitVector);
        this.encodedEncryptedContent = Base64UrlUtility.encode((byte[])encryptedContentNoTag);
        this.encodedAuthTag = Base64UrlUtility.encode((byte[])authenticationTag);
    }

    public JweCompactProducer(JweHeaders headers, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentWithTag, int authTagLengthBits) {
        this(headers, null, encryptedContentEncryptionKey, cipherInitVector, encryptedContentWithTag, authTagLengthBits);
    }

    public JweCompactProducer(JweHeaders headers, JoseHeadersWriter writer, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector, byte[] encryptedContentWithTag, int authTagLengthBits) {
        this.jweContentBuilder = JweCompactProducer.startJweContent(new StringBuilder(), headers, writer, encryptedContentEncryptionKey, cipherInitVector);
        this.encodedEncryptedContent = Base64UrlUtility.encodeChunk((byte[])encryptedContentWithTag, (int)0, (int)(encryptedContentWithTag.length - authTagLengthBits / 8));
        this.encodedAuthTag = Base64UrlUtility.encodeChunk((byte[])encryptedContentWithTag, (int)(encryptedContentWithTag.length - authTagLengthBits / 8), (int)(authTagLengthBits / 8));
    }

    public static String startJweContent(JweHeaders headers, JoseHeadersWriter writer, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) {
        return JweCompactProducer.startJweContent(new StringBuilder(), headers, writer, encryptedContentEncryptionKey, cipherInitVector).toString();
    }

    public static StringBuilder startJweContent(StringBuilder sb, JweHeaders headers, JoseHeadersWriter writer, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) {
        return JweCompactProducer.startJweContent(sb, JweCompactProducer.getHeadersJson(headers, writer), encryptedContentEncryptionKey, cipherInitVector);
    }

    private static String getHeadersJson(JweHeaders headers, JoseHeadersWriter writer) {
        writer = writer == null ? new JoseHeadersReaderWriter() : writer;
        return writer.headersToJson(headers);
    }

    public static StringBuilder startJweContent(StringBuilder sb, String headersJson, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) {
        String encodedHeaders = Base64UrlUtility.encode((String)headersJson);
        String encodedContentEncryptionKey = Base64UrlUtility.encode((byte[])encryptedContentEncryptionKey);
        String encodedInitVector = Base64UrlUtility.encode((byte[])cipherInitVector);
        sb.append(encodedHeaders).append('.').append(encodedContentEncryptionKey == null ? "" : encodedContentEncryptionKey).append('.').append(encodedInitVector == null ? "" : encodedInitVector).append('.');
        return sb;
    }

    public static void startJweContent(OutputStream os, JweHeaders headers, JoseHeadersWriter writer, byte[] encryptedContentEncryptionKey, byte[] cipherInitVector) throws IOException {
        writer = writer == null ? new JwtTokenReaderWriter() : writer;
        byte[] jsonBytes = writer.headersToJson(headers).getBytes("UTF-8");
        Base64UrlUtility.encodeAndStream((byte[])jsonBytes, (int)0, (int)jsonBytes.length, (OutputStream)os);
        byte[] dotBytes = new byte[]{46};
        os.write(dotBytes);
        Base64UrlUtility.encodeAndStream((byte[])encryptedContentEncryptionKey, (int)0, (int)encryptedContentEncryptionKey.length, (OutputStream)os);
        os.write(dotBytes);
        Base64UrlUtility.encodeAndStream((byte[])cipherInitVector, (int)0, (int)cipherInitVector.length, (OutputStream)os);
        os.write(dotBytes);
    }

    public String getJweContent() {
        return this.jweContentBuilder.append(this.encodedEncryptedContent).append('.').append(this.encodedAuthTag).toString();
    }
}

