/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import javax.crypto.SecretKey;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesGcmWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.ContentEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAOaepKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.RSAOaepKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.WrappedKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;

public final class JweUtils {
    private JweUtils() {
    }

    public static KeyEncryptionAlgorithm getKeyEncryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getKeyEncryptionAlgorithm(jwk, null);
    }

    public static KeyEncryptionAlgorithm getKeyEncryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String keyEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        AbstractWrapKeyEncryptionAlgorithm keyEncryptionProvider = null;
        if ("RSA".equals(jwk.getKeyType())) {
            keyEncryptionProvider = new RSAOaepKeyEncryptionAlgorithm(JwkUtils.toRSAPublicKey(jwk), keyEncryptionAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            SecretKey key = JwkUtils.toSecretKey(jwk);
            if (Algorithm.isAesKeyWrap(keyEncryptionAlgo)) {
                keyEncryptionProvider = new AesWrapKeyEncryptionAlgorithm(key, keyEncryptionAlgo);
            } else if (Algorithm.isAesGcmKeyWrap(keyEncryptionAlgo)) {
                keyEncryptionProvider = new AesGcmWrapKeyEncryptionAlgorithm(key, keyEncryptionAlgo);
            }
        }
        return keyEncryptionProvider;
    }

    public static KeyDecryptionAlgorithm getKeyDecryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getKeyDecryptionAlgorithm(jwk, null);
    }

    public static KeyDecryptionAlgorithm getKeyDecryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String keyEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        WrappedKeyDecryptionAlgorithm keyDecryptionProvider = null;
        if ("RSA".equals(jwk.getKeyType())) {
            keyDecryptionProvider = new RSAOaepKeyDecryptionAlgorithm(JwkUtils.toRSAPrivateKey(jwk), keyEncryptionAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            SecretKey key = JwkUtils.toSecretKey(jwk);
            if (Algorithm.isAesKeyWrap(jwk.getAlgorithm())) {
                keyDecryptionProvider = new AesWrapKeyDecryptionAlgorithm(key, keyEncryptionAlgo);
            } else if (Algorithm.isAesGcmKeyWrap(jwk.getAlgorithm())) {
                keyDecryptionProvider = new AesGcmWrapKeyDecryptionAlgorithm(key, keyEncryptionAlgo);
            }
        }
        return keyDecryptionProvider;
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(JsonWebKey jwk) {
        return JweUtils.getContentEncryptionAlgorithm(jwk, null);
    }

    public static ContentEncryptionAlgorithm getContentEncryptionAlgorithm(JsonWebKey jwk, String defaultAlgorithm) {
        String ctEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        AesGcmContentEncryptionAlgorithm contentEncryptionProvider = null;
        if ("oct".equals(jwk.getKeyType())) {
            SecretKey key = JwkUtils.toSecretKey(jwk);
            if (Algorithm.isAesGcm(ctEncryptionAlgo)) {
                contentEncryptionProvider = new AesGcmContentEncryptionAlgorithm(key, null, ctEncryptionAlgo);
            }
        }
        return contentEncryptionProvider;
    }

    public static SecretKey getContentDecryptionSecretKey(JsonWebKey jwk) {
        return JweUtils.getContentDecryptionSecretKey(jwk, null);
    }

    public static SecretKey getContentDecryptionSecretKey(JsonWebKey jwk, String defaultAlgorithm) {
        String ctEncryptionAlgo;
        String string = ctEncryptionAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        if ("oct".equals(jwk.getKeyType()) && Algorithm.isAesGcm(ctEncryptionAlgo)) {
            return JwkUtils.toSecretKey(jwk);
        }
        return null;
    }
}

