/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.PbesHmacAesWrapKeyEncryptionAlgorithm;

public class PbesHmacAesWrapKeyDecryptionAlgorithm
implements KeyDecryptionAlgorithm {
    private byte[] password;

    public PbesHmacAesWrapKeyDecryptionAlgorithm(String password) {
        this(PbesHmacAesWrapKeyEncryptionAlgorithm.stringToBytes(password));
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(char[] password) {
        this(PbesHmacAesWrapKeyEncryptionAlgorithm.charsToBytes(password));
    }

    public PbesHmacAesWrapKeyDecryptionAlgorithm(byte[] password) {
        this.password = password;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweCompactConsumer consumer) {
        byte[] saltInput = this.getDecodedBytes(consumer, "p2s");
        int pbesCount = consumer.getJweHeaders().getIntegerHeader("p2c");
        String keyAlgoJwt = consumer.getJweHeaders().getAlgorithm();
        int keySize = PbesHmacAesWrapKeyEncryptionAlgorithm.getKeySize(keyAlgoJwt);
        byte[] derivedKey = PbesHmacAesWrapKeyEncryptionAlgorithm.createDerivedKey(keyAlgoJwt, keySize, this.password, saltInput, pbesCount);
        AesWrapKeyDecryptionAlgorithm aesWrap = new AesWrapKeyDecryptionAlgorithm(derivedKey);
        return aesWrap.getDecryptedContentEncryptionKey(consumer);
    }

    private byte[] getDecodedBytes(JweCompactConsumer consumer, String headerName) {
        try {
            Object headerValue = consumer.getJweHeaders().getHeader(headerName);
            return Base64UrlUtility.decode((String)headerValue.toString());
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }
}

