/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public class PbesHmacAesWrapKeyEncryptionAlgorithm
implements KeyEncryptionAlgorithm {
    private static final Set<String> SUPPORTED_ALGORITHMS = new HashSet<String>(Arrays.asList(Algorithm.PBES2_HS256_A128KW.getJwtName(), Algorithm.PBES2_HS384_A192KW.getJwtName(), Algorithm.PBES2_HS512_A256KW.getJwtName()));
    private static final Map<String, Integer> PBES_HMAC_MAP = new HashMap<String, Integer>();
    private static final Map<String, String> PBES_AES_MAP;
    private static final Map<String, Integer> DERIVED_KEY_SIZE_MAP;
    private byte[] password;
    private int pbesCount;
    private String keyAlgoJwt;

    public PbesHmacAesWrapKeyEncryptionAlgorithm(String password, String keyAlgoJwt) {
        this(PbesHmacAesWrapKeyEncryptionAlgorithm.stringToBytes(password), keyAlgoJwt);
    }

    public PbesHmacAesWrapKeyEncryptionAlgorithm(String password, int pbesCount, String keyAlgoJwt) {
        this(PbesHmacAesWrapKeyEncryptionAlgorithm.stringToBytes(password), pbesCount, keyAlgoJwt);
    }

    public PbesHmacAesWrapKeyEncryptionAlgorithm(char[] password, String keyAlgoJwt) {
        this(password, 4096, keyAlgoJwt);
    }

    public PbesHmacAesWrapKeyEncryptionAlgorithm(char[] password, int pbesCount, String keyAlgoJwt) {
        this(PbesHmacAesWrapKeyEncryptionAlgorithm.charsToBytes(password), pbesCount, keyAlgoJwt);
    }

    public PbesHmacAesWrapKeyEncryptionAlgorithm(byte[] password, String keyAlgoJwt) {
        this(password, 4096, keyAlgoJwt);
    }

    public PbesHmacAesWrapKeyEncryptionAlgorithm(byte[] password, int pbesCount, String keyAlgoJwt) {
        this.password = password;
        this.keyAlgoJwt = PbesHmacAesWrapKeyEncryptionAlgorithm.validateKeyAlgorithm(keyAlgoJwt);
        this.pbesCount = PbesHmacAesWrapKeyEncryptionAlgorithm.validatePbesCount(pbesCount);
    }

    @Override
    public byte[] getEncryptedContentEncryptionKey(JweHeaders headers, byte[] cek) {
        int keySize = PbesHmacAesWrapKeyEncryptionAlgorithm.getKeySize(this.keyAlgoJwt);
        byte[] saltInput = CryptoUtils.generateSecureRandomBytes((int)keySize);
        byte[] derivedKey = PbesHmacAesWrapKeyEncryptionAlgorithm.createDerivedKey(this.keyAlgoJwt, keySize, this.password, saltInput, this.pbesCount);
        headers.setHeader("p2s", Base64UrlUtility.encode((byte[])saltInput));
        headers.setIntegerHeader("p2c", this.pbesCount);
        String aesAlgoJwt = PBES_AES_MAP.get(this.keyAlgoJwt);
        AesWrapKeyEncryptionAlgorithm aesWrap = new AesWrapKeyEncryptionAlgorithm(derivedKey, aesAlgoJwt){

            @Override
            protected void checkAlgorithms(JweHeaders headers) {
            }

            @Override
            protected String getKeyEncryptionAlgoJava(JweHeaders headers) {
                return "AESWrap";
            }
        };
        return aesWrap.getEncryptedContentEncryptionKey(headers, cek);
    }

    static int getKeySize(String keyAlgoJwt) {
        return DERIVED_KEY_SIZE_MAP.get(keyAlgoJwt);
    }

    static byte[] createDerivedKey(String keyAlgoJwt, int keySize, byte[] password, byte[] saltInput, int pbesCount) {
        byte[] saltValue = PbesHmacAesWrapKeyEncryptionAlgorithm.createSaltValue(keyAlgoJwt, saltInput);
        Object digest = null;
        int macSigSize = PBES_HMAC_MAP.get(keyAlgoJwt);
        digest = macSigSize == 256 ? new SHA256Digest() : (macSigSize == 384 ? new SHA384Digest() : new SHA512Digest());
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)digest);
        gen.init(password, saltValue, pbesCount);
        return ((KeyParameter)gen.generateDerivedParameters(keySize * 8)).getKey();
    }

    private static byte[] createSaltValue(String keyAlgoJwt, byte[] saltInput) {
        byte[] algoBytes = PbesHmacAesWrapKeyEncryptionAlgorithm.stringToBytes(keyAlgoJwt);
        byte[] saltValue = new byte[algoBytes.length + 1 + saltInput.length];
        System.arraycopy(algoBytes, 0, saltValue, 0, algoBytes.length);
        saltValue[algoBytes.length] = 0;
        System.arraycopy(saltInput, 0, saltValue, algoBytes.length + 1, saltInput.length);
        return saltValue;
    }

    static String validateKeyAlgorithm(String algo) {
        if (!SUPPORTED_ALGORITHMS.contains(algo)) {
            throw new SecurityException();
        }
        return algo;
    }

    static int validatePbesCount(int count) {
        if (count < 1000) {
            throw new SecurityException();
        }
        return count;
    }

    static byte[] stringToBytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SecurityException(ex);
        }
    }

    static byte[] charsToBytes(char[] chars) {
        ByteBuffer bb = Charset.forName("UTF-8").encode(CharBuffer.wrap(chars));
        byte[] b = new byte[bb.remaining()];
        bb.get(b);
        return b;
    }

    @Override
    public String getAlgorithm() {
        return this.keyAlgoJwt;
    }

    static {
        PBES_HMAC_MAP.put(Algorithm.PBES2_HS256_A128KW.getJwtName(), 256);
        PBES_HMAC_MAP.put(Algorithm.PBES2_HS384_A192KW.getJwtName(), 384);
        PBES_HMAC_MAP.put(Algorithm.PBES2_HS512_A256KW.getJwtName(), 512);
        PBES_AES_MAP = new HashMap<String, String>();
        PBES_AES_MAP.put(Algorithm.PBES2_HS256_A128KW.getJwtName(), Algorithm.A128KW.getJwtName());
        PBES_AES_MAP.put(Algorithm.PBES2_HS384_A192KW.getJwtName(), Algorithm.A192KW.getJwtName());
        PBES_AES_MAP.put(Algorithm.PBES2_HS512_A256KW.getJwtName(), Algorithm.A256KW.getJwtName());
        DERIVED_KEY_SIZE_MAP = new HashMap<String, Integer>();
        DERIVED_KEY_SIZE_MAP.put(Algorithm.PBES2_HS256_A128KW.getJwtName(), 16);
        DERIVED_KEY_SIZE_MAP.put(Algorithm.PBES2_HS384_A192KW.getJwtName(), 24);
        DERIVED_KEY_SIZE_MAP.put(Algorithm.PBES2_HS512_A256KW.getJwtName(), 32);
    }
}

