/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.common.util.crypto.KeyProperties;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.JweCompactConsumer;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;

public class WrappedKeyDecryptionAlgorithm
implements KeyDecryptionAlgorithm {
    private Key cekDecryptionKey;
    private boolean unwrap;
    private String supportedAlgo;

    public WrappedKeyDecryptionAlgorithm(Key cekDecryptionKey) {
        this(cekDecryptionKey, null);
    }

    public WrappedKeyDecryptionAlgorithm(Key cekDecryptionKey, String supportedAlgo) {
        this(cekDecryptionKey, supportedAlgo, true);
    }

    public WrappedKeyDecryptionAlgorithm(Key cekDecryptionKey, String supportedAlgo, boolean unwrap) {
        this.cekDecryptionKey = cekDecryptionKey;
        this.supportedAlgo = supportedAlgo;
        this.unwrap = unwrap;
    }

    @Override
    public byte[] getDecryptedContentEncryptionKey(JweCompactConsumer consumer) {
        KeyProperties keyProps = new KeyProperties(this.getKeyEncryptionAlgorithm(consumer));
        AlgorithmParameterSpec spec = this.getAlgorithmParameterSpec(consumer);
        if (spec != null) {
            keyProps.setAlgoSpec(spec);
        }
        if (!this.unwrap) {
            keyProps.setBlockSize(this.getKeyCipherBlockSize());
            return CryptoUtils.decryptBytes((byte[])this.getEncryptedContentEncryptionKey(consumer), (Key)this.getCekDecryptionKey(), (KeyProperties)keyProps);
        }
        return CryptoUtils.unwrapSecretKey((byte[])this.getEncryptedContentEncryptionKey(consumer), (String)this.getContentEncryptionAlgorithm(consumer), (Key)this.getCekDecryptionKey(), (KeyProperties)keyProps).getEncoded();
    }

    protected Key getCekDecryptionKey() {
        return this.cekDecryptionKey;
    }

    protected int getKeyCipherBlockSize() {
        return -1;
    }

    protected String getKeyEncryptionAlgorithm(JweCompactConsumer consumer) {
        String keyAlgo = consumer.getJweHeaders().getKeyEncryptionAlgorithm();
        return Algorithm.toJavaName(keyAlgo);
    }

    protected void validateKeyEncryptionAlgorithm(String keyAlgo) {
        if (keyAlgo == null || this.supportedAlgo != null && this.supportedAlgo.equals(keyAlgo)) {
            throw new SecurityException();
        }
    }

    protected String getContentEncryptionAlgorithm(JweCompactConsumer consumer) {
        return Algorithm.toJavaName(consumer.getJweHeaders().getContentEncryptionAlgorithm());
    }

    protected AlgorithmParameterSpec getAlgorithmParameterSpec(JweCompactConsumer consumer) {
        return null;
    }

    protected byte[] getEncryptedContentEncryptionKey(JweCompactConsumer consumer) {
        return consumer.getEncryptedContentEncryptionKey();
    }
}

