/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwk;

import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.jose.AbstractJoseObject;

public class JsonWebKey
extends AbstractJoseObject {
    public static final String KEY_TYPE = "kty";
    public static final String PUBLIC_KEY_USE = "use";
    public static final String KEY_OPERATIONS = "key_ops";
    public static final String KEY_ALGO = "alg";
    public static final String KEY_ID = "kid";
    public static final String X509_URL = "x5u";
    public static final String X509_CHAIN = "x5c";
    public static final String X509_THUMBPRINT = "x5t";
    public static final String X509_THUMBPRINT_SHA256 = "x5t#S256";
    public static final String KEY_TYPE_RSA = "RSA";
    public static final String RSA_MODULUS = "n";
    public static final String RSA_PUBLIC_EXP = "e";
    public static final String RSA_PRIVATE_EXP = "d";
    public static final String RSA_FIRST_PRIME_FACTOR = "p";
    public static final String RSA_SECOND_PRIME_FACTOR = "q";
    public static final String RSA_FIRST_PRIME_CRT = "dp";
    public static final String RSA_SECOND_PRIME_CRT = "dq";
    public static final String RSA_FIRST_CRT_COEFFICIENT = "qi";
    public static final String KEY_TYPE_OCTET = "oct";
    public static final String OCTET_KEY_VALUE = "k";
    public static final String KEY_TYPE_ELLIPTIC = "EC";
    public static final String EC_CURVE = "crv";
    public static final String EC_CURVE_P256 = "P-256";
    public static final String EC_CURVE_P384 = "P-384";
    public static final String EC_CURVE_P512 = "P-512";
    public static final String EC_X_COORDINATE = "x";
    public static final String EC_Y_COORDINATE = "y";
    public static final String EC_PRIVATE_KEY = "d";
    public static final String PUBLIC_KEY_USE_SIGN = "sig";
    public static final String PUBLIC_KEY_USE_ENCRYPT = "enc";
    public static final String KEY_OPER_SIGN = "sign";
    public static final String KEY_OPER_VERIFY = "verify";
    public static final String KEY_OPER_ENCRYPT = "encrypt";
    public static final String KEY_OPER_DECRYPT = "decrypt";

    public JsonWebKey() {
    }

    public JsonWebKey(Map<String, Object> values) {
        super(values);
    }

    public void setKeyType(String keyType) {
        super.setValue(KEY_TYPE, keyType);
    }

    public String getKeyType() {
        return (String)super.getValue(KEY_TYPE);
    }

    public void setPublicKeyUse(String use) {
        super.setValue(PUBLIC_KEY_USE, use);
    }

    public String getPublicKeyUse() {
        return (String)super.getValue(PUBLIC_KEY_USE);
    }

    public void setKeyOperation(List<String> keyOperation) {
        super.setValue(KEY_OPERATIONS, keyOperation);
    }

    public List<String> getKeyOperation() {
        return CastUtils.cast((List)((List)super.getValue(KEY_OPERATIONS)));
    }

    public void setAlgorithm(String algorithm) {
        super.setValue(KEY_ALGO, algorithm);
    }

    public String getAlgorithm() {
        return (String)super.getValue(KEY_ALGO);
    }

    public void setKid(String kid) {
        super.setValue(KEY_ID, kid);
    }

    public String getKid() {
        return (String)super.getValue(KEY_ID);
    }

    public void setX509Url(String x509Url) {
        super.setValue(X509_URL, x509Url);
    }

    public String getX509Url() {
        return (String)super.getValue(X509_URL);
    }

    public void setX509Chain(String x509Chain) {
        super.setValue(X509_CHAIN, x509Chain);
    }

    public String getX509Chain() {
        return (String)super.getValue(X509_CHAIN);
    }

    public void setX509Thumbprint(String x509Thumbprint) {
        super.setValue(X509_THUMBPRINT, x509Thumbprint);
    }

    public String getX509Thumbprint() {
        return (String)super.getValue(X509_THUMBPRINT);
    }

    public void setX509ThumbprintSHA256(String x509Thumbprint) {
        super.setValue(X509_THUMBPRINT_SHA256, x509Thumbprint);
    }

    public String getX509ThumbprintSHA256() {
        return (String)super.getValue(X509_THUMBPRINT_SHA256);
    }

    public JsonWebKey setProperty(String name, Object value) {
        super.setValue(name, value);
        return this;
    }

    public Object getProperty(String name) {
        return super.getValue(name);
    }
}

