/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwk;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.rs.security.jose.AbstractJoseObject;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;

public class JsonWebKeys
extends AbstractJoseObject {
    public static final String KEYS_PROPERTY = "keys";

    public List<JsonWebKey> getKeys() {
        List list = (List)super.getValue(KEYS_PROPERTY);
        if (list != null && !list.isEmpty()) {
            Object first = list.get(0);
            if (first instanceof JsonWebKey) {
                return CastUtils.cast((List)list);
            }
            LinkedList<JsonWebKey> keys = new LinkedList<JsonWebKey>();
            List listOfMaps = CastUtils.cast((List)((List)super.getValue(KEYS_PROPERTY)));
            for (Map map : listOfMaps) {
                keys.add(new JsonWebKey(map));
            }
            return keys;
        }
        return null;
    }

    public void setKeys(List<JsonWebKey> keys) {
        super.setValue(KEYS_PROPERTY, keys);
    }

    public Map<String, JsonWebKey> getKeyIdMap() {
        List<JsonWebKey> keys = this.getKeys();
        if (keys == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, JsonWebKey> map = new LinkedHashMap<String, JsonWebKey>();
        for (JsonWebKey key : keys) {
            String kid = key.getKid();
            if (kid == null) continue;
            map.put(kid, key);
        }
        return map;
    }

    public JsonWebKey getKey(String kid) {
        return this.getKeyIdMap().get(kid);
    }

    public Map<String, List<JsonWebKey>> getKeyTypeMap() {
        return this.getKeyPropertyMap("kty");
    }

    public Map<String, List<JsonWebKey>> getKeyUseMap() {
        return this.getKeyPropertyMap("use");
    }

    private Map<String, List<JsonWebKey>> getKeyPropertyMap(String propertyName) {
        List<JsonWebKey> keys = this.getKeys();
        if (keys == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<JsonWebKey>> map = new LinkedHashMap<String, List<JsonWebKey>>();
        for (JsonWebKey key : keys) {
            String propValue = (String)key.getProperty(propertyName);
            if (propValue == null) continue;
            LinkedList<JsonWebKey> list = (LinkedList<JsonWebKey>)map.get(propValue);
            if (list == null) {
                list = new LinkedList<JsonWebKey>();
                map.put(propValue, list);
            }
            list.add(key);
        }
        return map;
    }

    public Map<String, List<JsonWebKey>> getKeyOperationMap() {
        List<JsonWebKey> keys = this.getKeys();
        if (keys == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, List<JsonWebKey>> map = new LinkedHashMap<String, List<JsonWebKey>>();
        for (JsonWebKey key : keys) {
            List<String> ops = key.getKeyOperation();
            if (ops == null) continue;
            for (String op : ops) {
                LinkedList<JsonWebKey> list = (LinkedList<JsonWebKey>)map.get(op);
                if (list == null) {
                    list = new LinkedList<JsonWebKey>();
                    map.put(op, list);
                }
                list.add(key);
            }
        }
        return map;
    }

    public List<JsonWebKey> getKeys(String keyType) {
        return this.getKeyTypeMap().get(keyType);
    }

    public List<JsonWebKey> getRsaKeys() {
        return this.getKeyTypeMap().get("RSA");
    }

    public List<JsonWebKey> getEllipticKeys() {
        return this.getKeyTypeMap().get("EC");
    }

    public List<JsonWebKey> getSecretKeys() {
        return this.getKeyTypeMap().get("oct");
    }
}

