/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwk;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.crypto.SecretKey;
import org.apache.cxf.Bus;
import org.apache.cxf.common.util.crypto.CryptoUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.jaxrs.PrivateKeyPasswordProvider;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweEncryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.KeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.PbesHmacAesWrapKeyDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.PbesHmacAesWrapKeyEncryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.DefaultJwkReaderWriter;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jwk.JwkReaderWriter;

public final class JwkUtils {
    public static final String JWK_KEY_STORE_TYPE = "jwk";
    public static final String RSSEC_KEY_STORE_JWKSET = "rs.security.keystore.jwkset";
    public static final String RSSEC_KEY_STORE_JWKKEY = "rs.security.keystore.jwkkey";

    private JwkUtils() {
    }

    public static JsonWebKey readJwkKey(InputStream is) throws IOException {
        return new DefaultJwkReaderWriter().jsonToJwk(IOUtils.readStringFromStream((InputStream)is));
    }

    public static JsonWebKeys readJwkSet(InputStream is) throws IOException {
        return new DefaultJwkReaderWriter().jsonToJwkSet(IOUtils.readStringFromStream((InputStream)is));
    }

    public static JsonWebKey readJwkKey(String jwkJson) {
        return new DefaultJwkReaderWriter().jsonToJwk(jwkJson);
    }

    public static JsonWebKeys readJwkSet(String jwksJson) {
        return new DefaultJwkReaderWriter().jsonToJwkSet(jwksJson);
    }

    public static String jwkKeyToJson(JsonWebKey jwkKey) {
        return new DefaultJwkReaderWriter().jwkToJson(jwkKey);
    }

    public static String jwkSetToJson(JsonWebKeys jwkSet) {
        return new DefaultJwkReaderWriter().jwkSetToJson(jwkSet);
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, char[] password) {
        return JwkUtils.encryptJwkSet(jwkSet, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, char[] password, JwkReaderWriter writer) {
        return JwkUtils.encryptJwkSet(jwkSet, JwkUtils.createDefaultEncryption(password), writer);
    }

    public static String encryptJwkSet(JsonWebKeys jwkSet, JweEncryptionProvider jwe, JwkReaderWriter writer) {
        return jwe.encrypt(JwkUtils.stringToBytes(writer.jwkSetToJson(jwkSet)), "jwk-set+json");
    }

    public static JsonWebKeys decryptJwkSet(String jsonJwkSet, char[] password) {
        return JwkUtils.decryptJwkSet(jsonJwkSet, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKeys decryptJwkSet(String jsonJwkSet, char[] password, JwkReaderWriter reader) {
        return JwkUtils.decryptJwkSet(jsonJwkSet, JwkUtils.createDefaultDecryption(password), reader);
    }

    public static JsonWebKeys decryptJwkSet(String jsonJwkSet, JweDecryptionProvider jwe, JwkReaderWriter reader) {
        return reader.jsonToJwkSet(jwe.decrypt(jsonJwkSet).getContentText());
    }

    public static JsonWebKeys decryptJwkSet(InputStream is, char[] password) throws IOException {
        return JwkUtils.decryptJwkSet(is, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKeys decryptJwkSet(InputStream is, char[] password, JwkReaderWriter reader) throws IOException {
        return JwkUtils.decryptJwkSet(is, JwkUtils.createDefaultDecryption(password), reader);
    }

    public static JsonWebKeys decryptJwkSet(InputStream is, JweDecryptionProvider jwe, JwkReaderWriter reader) throws IOException {
        return reader.jsonToJwkSet(jwe.decrypt(IOUtils.readStringFromStream((InputStream)is)).getContentText());
    }

    public static String encryptJwkKey(JsonWebKey jwk, char[] password) {
        return JwkUtils.encryptJwkKey(jwk, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, char[] password, JwkReaderWriter writer) {
        return JwkUtils.encryptJwkKey(jwkKey, JwkUtils.createDefaultEncryption(password), writer);
    }

    public static String encryptJwkKey(JsonWebKey jwkKey, JweEncryptionProvider jwe, JwkReaderWriter writer) {
        return jwe.encrypt(JwkUtils.stringToBytes(writer.jwkToJson(jwkKey)), "jwk+json");
    }

    public static JsonWebKey decryptJwkKey(String jsonJwkKey, char[] password) {
        return JwkUtils.decryptJwkKey(jsonJwkKey, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKey decryptJwkKey(String jsonJwkKey, char[] password, JwkReaderWriter reader) {
        return JwkUtils.decryptJwkKey(jsonJwkKey, JwkUtils.createDefaultDecryption(password), reader);
    }

    public static JsonWebKey decryptJwkKey(String jsonJwkKey, JweDecryptionProvider jwe, JwkReaderWriter reader) {
        return reader.jsonToJwk(jwe.decrypt(jsonJwkKey).getContentText());
    }

    public static JsonWebKey decryptJwkKey(InputStream is, char[] password) throws IOException {
        return JwkUtils.decryptJwkKey(is, password, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKey decryptJwkKey(InputStream is, char[] password, JwkReaderWriter reader) throws IOException {
        return JwkUtils.decryptJwkKey(is, JwkUtils.createDefaultDecryption(password), reader);
    }

    public static JsonWebKey decryptJwkKey(InputStream is, JweDecryptionProvider jwe, JwkReaderWriter reader) throws IOException {
        return reader.jsonToJwk(jwe.decrypt(IOUtils.readStringFromStream((InputStream)is)).getContentText());
    }

    private static JweEncryptionProvider createDefaultEncryption(char[] password) {
        PbesHmacAesWrapKeyEncryptionAlgorithm keyEncryption = new PbesHmacAesWrapKeyEncryptionAlgorithm(password, Algorithm.PBES2_HS256_A128KW.getJwtName());
        return new AesCbcHmacJweEncryption(Algorithm.A128CBC_HS256.getJwtName(), (KeyEncryptionAlgorithm)keyEncryption);
    }

    private static JweDecryptionProvider createDefaultDecryption(char[] password) {
        PbesHmacAesWrapKeyDecryptionAlgorithm keyDecryption = new PbesHmacAesWrapKeyDecryptionAlgorithm(password);
        return new AesCbcHmacJweDecryption(keyDecryption);
    }

    public static JsonWebKeys loadJwkSet(Message m, Properties props, PrivateKeyPasswordProvider cb) {
        return JwkUtils.loadJwkSet(m, props, cb, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKeys loadJwkSet(Message m, Properties props, PrivateKeyPasswordProvider cb, JwkReaderWriter reader) {
        JsonWebKeys jwkSet = (JsonWebKeys)m.getExchange().get(props.get("rs.security.keystore.file"));
        if (jwkSet == null) {
            jwkSet = JwkUtils.loadJwkSet(props, m.getExchange().getBus(), cb, reader);
            m.getExchange().put((Object)((String)props.get("rs.security.keystore.file")), (Object)jwkSet);
        }
        return jwkSet;
    }

    public static JsonWebKeys loadJwkSet(Properties props, Bus bus, PrivateKeyPasswordProvider cb) {
        return JwkUtils.loadJwkSet(props, bus, cb, (JwkReaderWriter)new DefaultJwkReaderWriter());
    }

    public static JsonWebKeys loadJwkSet(Properties props, Bus bus, PrivateKeyPasswordProvider cb, JwkReaderWriter reader) {
        AesCbcHmacJweDecryption decryption = cb != null ? new AesCbcHmacJweDecryption(new PbesHmacAesWrapKeyDecryptionAlgorithm(cb.getPassword(props))) : null;
        return JwkUtils.loadJwkSet(props, bus, decryption, reader);
    }

    public static JsonWebKeys loadJwkSet(Properties props, Bus bus, JweDecryptionProvider jwe, JwkReaderWriter reader) {
        String keyContent = null;
        String keyStoreLoc = props.getProperty("rs.security.keystore.file");
        if (keyStoreLoc != null) {
            try {
                InputStream is = ResourceUtils.getResourceStream((String)keyStoreLoc, (Bus)bus);
                keyContent = IOUtils.readStringFromStream((InputStream)is);
            }
            catch (Exception ex) {
                throw new SecurityException(ex);
            }
        } else {
            keyContent = props.getProperty(RSSEC_KEY_STORE_JWKSET);
            if (keyContent == null) {
                keyContent = props.getProperty(RSSEC_KEY_STORE_JWKKEY);
            }
        }
        if (jwe != null) {
            keyContent = jwe.decrypt(keyContent).getContentText();
        }
        if (props.getProperty(RSSEC_KEY_STORE_JWKKEY) == null) {
            return reader.jsonToJwkSet(keyContent);
        }
        JsonWebKey key = reader.jsonToJwk(keyContent);
        JsonWebKeys keys = new JsonWebKeys();
        keys.setKeys(Collections.singletonList(key));
        return keys;
    }

    public static JsonWebKey loadJsonWebKey(Message m, Properties props, String keyOper) {
        return JwkUtils.loadJsonWebKey(m, props, keyOper, new DefaultJwkReaderWriter());
    }

    public static JsonWebKey loadJsonWebKey(Message m, Properties props, String keyOper, JwkReaderWriter reader) {
        List<JsonWebKey> keys;
        PrivateKeyPasswordProvider cb = (PrivateKeyPasswordProvider)m.getContextualProperty("rs.security.key.password.provider");
        if (cb == null && keyOper != null) {
            String propName;
            String string = keyOper.equals("sign") ? "rs.security.signature.key.password.provider" : (propName = keyOper.equals("encrypt") ? "rs.security.decryption.key.password.provider" : null);
            if (propName != null) {
                cb = (PrivateKeyPasswordProvider)m.getContextualProperty(propName);
            }
        }
        JsonWebKeys jwkSet = JwkUtils.loadJwkSet(m, props, cb, reader);
        String kid = props.getProperty("rs.security.keystore.alias");
        if (kid == null && keyOper != null) {
            String keyIdProp = null;
            if (keyOper.equals("encrypt")) {
                keyIdProp = "rs.security.keystore.alias.jwe";
            } else if (keyOper.equals("sign") || keyOper.equals("verify")) {
                keyIdProp = "rs.security.keystore.alias.jws";
            }
            if (keyIdProp != null) {
                kid = props.getProperty(keyIdProp);
            }
        }
        if (kid != null) {
            return jwkSet.getKey(kid);
        }
        if (keyOper != null && (keys = jwkSet.getKeyUseMap().get(keyOper)) != null && keys.size() == 1) {
            return keys.get(0);
        }
        return null;
    }

    public static RSAPublicKey toRSAPublicKey(JsonWebKey jwk) {
        String encodedModulus = (String)jwk.getProperty("n");
        String encodedPublicExponent = (String)jwk.getProperty("e");
        return CryptoUtils.getRSAPublicKey((String)encodedModulus, (String)encodedPublicExponent);
    }

    public static RSAPrivateKey toRSAPrivateKey(JsonWebKey jwk) {
        String encodedModulus = (String)jwk.getProperty("n");
        String encodedPrivateExponent = (String)jwk.getProperty("d");
        String encodedPrimeP = (String)jwk.getProperty("p");
        if (encodedPrimeP == null) {
            return CryptoUtils.getRSAPrivateKey((String)encodedModulus, (String)encodedPrivateExponent);
        }
        String encodedPublicExponent = (String)jwk.getProperty("e");
        String encodedPrimeQ = (String)jwk.getProperty("q");
        String encodedPrimeExpP = (String)jwk.getProperty("dp");
        String encodedPrimeExpQ = (String)jwk.getProperty("dq");
        String encodedCrtCoefficient = (String)jwk.getProperty("qi");
        return CryptoUtils.getRSAPrivateKey((String)encodedModulus, (String)encodedPublicExponent, (String)encodedPrivateExponent, (String)encodedPrimeP, (String)encodedPrimeQ, (String)encodedPrimeExpP, (String)encodedPrimeExpQ, (String)encodedCrtCoefficient);
    }

    public static ECPublicKey toECPublicKey(JsonWebKey jwk) {
        String eCurve = (String)jwk.getProperty("crv");
        String encodedXCoord = (String)jwk.getProperty("x");
        String encodedYCoord = (String)jwk.getProperty("y");
        return CryptoUtils.getECPublicKey((String)eCurve, (String)encodedXCoord, (String)encodedYCoord);
    }

    public static ECPrivateKey toECPrivateKey(JsonWebKey jwk) {
        String eCurve = (String)jwk.getProperty("crv");
        String encodedPrivateKey = (String)jwk.getProperty("d");
        return CryptoUtils.getECPrivateKey((String)eCurve, (String)encodedPrivateKey);
    }

    public static SecretKey toSecretKey(JsonWebKey jwk) {
        return CryptoUtils.createSecretKeySpec((String)((String)jwk.getProperty("k")), (String)Algorithm.toJavaName(jwk.getAlgorithm()));
    }

    private static byte[] stringToBytes(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SecurityException(ex);
        }
    }
}

