/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

public abstract class AbstractJwsSignatureProvider
implements JwsSignatureProvider {
    private String algorithm;

    protected AbstractJwsSignatureProvider(String algo) {
        this.algorithm = algo;
    }

    protected JwsHeaders prepareHeaders(JwsHeaders headers) {
        String algo;
        if (headers == null) {
            headers = new JwsHeaders();
        }
        if ((algo = headers.getAlgorithm()) != null) {
            this.checkAlgorithm(algo);
        } else {
            this.checkAlgorithm(this.algorithm);
            headers.setAlgorithm(this.algorithm);
        }
        return headers;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public JwsSignature createJwsSignature(JwsHeaders headers) {
        return this.doCreateJwsSignature(this.prepareHeaders(headers));
    }

    protected abstract JwsSignature doCreateJwsSignature(JwsHeaders var1);

    protected void checkAlgorithm(String algo) {
        if (algo == null) {
            throw new SecurityException();
        }
    }
}

