/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.crypto.HmacUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jwt.JwtHeaders;

public class HmacJwsSignatureVerifier
implements JwsSignatureVerifier {
    private byte[] key;
    private AlgorithmParameterSpec hmacSpec;
    private String supportedAlgo;

    public HmacJwsSignatureVerifier(byte[] key) {
        this(key, null);
    }

    public HmacJwsSignatureVerifier(byte[] key, AlgorithmParameterSpec spec) {
        this(key, spec, null);
    }

    public HmacJwsSignatureVerifier(byte[] key, AlgorithmParameterSpec spec, String supportedAlgo) {
        this.key = key;
        this.hmacSpec = spec;
        this.supportedAlgo = supportedAlgo;
    }

    public HmacJwsSignatureVerifier(String encodedKey) {
        this(encodedKey, null);
    }

    public HmacJwsSignatureVerifier(String encodedKey, String supportedAlgo) {
        try {
            this.key = Base64UrlUtility.decode((String)encodedKey);
        }
        catch (Base64Exception ex) {
            throw new SecurityException();
        }
        this.supportedAlgo = supportedAlgo;
    }

    @Override
    public boolean verify(JwtHeaders headers, String unsignedText, byte[] signature) {
        byte[] expected = this.computeMac(headers, unsignedText);
        return Arrays.equals(expected, signature);
    }

    private byte[] computeMac(JwtHeaders headers, String text) {
        return HmacUtils.computeHmac((byte[])this.key, (String)Algorithm.toJavaName(this.checkAlgorithm(headers.getAlgorithm())), (AlgorithmParameterSpec)this.hmacSpec, (String)text);
    }

    protected String checkAlgorithm(String algo) {
        if (algo == null || !Algorithm.isHmacSign(algo) || this.supportedAlgo != null && !this.supportedAlgo.equals(algo)) {
            throw new SecurityException();
        }
        return algo;
    }
}

